<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.3
 */
class StringUtil{
	function getEncodeTypeUTF8(){
		return "UTF-8";
	}
	function getEncodeTypeSJIS(){
		return "SJIS";
	}
	function getEncodeTypeEUC(){
		return "EUC-JP";
	}
	function getEncodeTypeJIS(){
		return "JIS";
	}
	function encoding($value,$encodeType,$lang="Japanese"){
		if(!empty($encodeType)){
			if(extension_loaded("mbstring")){
				if(!empty($encodeType) && !empty($value)){
					if(!empty($lang)){
						 mb_language($lang);
					}
					if("neutral" == mb_language()){
						mb_language("Japanese");
					}
					return@mb_convert_encoding($value,$encodeType,mb_detect_encoding($value));
				}
			}else{
				$dir = (defined("RHACO_DIR")?constant("RHACO_DIR"):"")."library/";
				
				if(@include_once($dir."jcode/code_table.ucs2jis")){
					if(@include_once($dir."jcode/code_table.jis2ucs")){
						if(@include_once($dir."jcode/jcode.php")){
							if($encodeType == "EUC-JP"){	$encodeType = 1;	}
							else if($encodeType == "SJIS"){	$encodeType = 2;	}								
							else if($encodeType == "JIS"){	$encodeType = 3;	}
							else{							$encodeType = 4;	}
	
							return JcodeConvert($value,0,$encodeType);
						}
					}
				}
			}
		}
		return $value;
	}

	function convertKana($value){
		if(extension_loaded("mbstring")){
			return mb_convert_kana($value,"KV");
		}
		return $value;
	}
	function convertHanzen($value,$encodeType=""){
		if(extension_loaded("mbstring")){
			return mb_convert_kana($value,"asK",$encodeType);
		}else{
			$dir = (defined("RHACO_DIR")?constant("RHACO_DIR"):"")."library/";
			
			if(@include_once($dir."jcode/code_table.ucs2jis")){
				if(@include_once($dir."jcode/code_table.jis2ucs")){
					if(@include_once($dir."jcode/jcode.php")){
						if($encodeType == "EUC-JP"){		$encodeType = 1;	}
						else if($encodeType == "SJIS"){	$encodeType = 2;	}								
						else if($encodeType == "JIS"){	$encodeType = 3;	}
						else{							$encodeType = 4;	}
						
						return HANtoZEN($value,$encodeType);
					}
				}
			}
		}
		return $value;		
	}

	function getDetectEncoding($str="ラコホラス"){
		if(extension_loaded("mbstring")){
			return mb_detect_encoding($str);
		}else{
			$dir = (defined("RHACO_DIR")?constant("RHACO_DIR"):"")."library/";
			
			if(@include_once($dir."jcode/code_table.ucs2jis")){
				if(@include_once($dir."jcode/code_table.jis2ucs")){
					if(@include_once($dir."jcode/jcode.php")){
						switch(AutoDetect($str)){
							case 1:
								return "EUC-JP";
							case 2:
								return "SJIS";
							case 3:
								return "JIS";
							default:
								return "UTF-8";
						}
					}
				}
			}
		}
		return "UTF-8";
	}

	function replace($src,$preg,$replace="",$option=""){
		if(!empty($preg)){
			if(substr($preg,0,1) == "/"){
				if(extension_loaded("mbstring")){
					if(strpos($option,"i") === false){
						return mb_ereg_replace(substr($preg,1,-1),$replace,$src);						
					}
					return mb_eregi_replace(substr($preg,1,-1),$replace,$src);
				}
				return preg_replace(sprintf("%s%s",$preg,$option),$replace="",$src);
			}
			return str_replace($preg,$replace,$src);
		}
		return $src;
	}

	function strlen($str){
		if(extension_loaded("mbstring")){
			return mb_strlen($str);
		}
		return strlen($str);
	}

	function substring($str,$start,$length=""){
		if(extension_loaded("mbstring")){
			mb_substr($str,$start,$length);
		}
		return substr($str,$start,$length);
	}

	function getIncludeSeparate(){
		if(!empty($_SERVER["WINDIR"]) || !empty($_SERVER["PROGRAMFILES"])){		
			return ";";
		}
		return ":";	
	}
	function clearTag($src){
		return htmlspecialchars($src);
	}
	function getJsDocument($src){
		$src = preg_replace("/([\"\'])/","\\\\\\1",$src);
		$src = str_replace("\n","\\\\n",$src);
		$src = str_replace("\r","\\\\r",$src);

		return $src;
	}
	
	function sprintf(){
		$argList		= func_get_args();
		$argsize		= sizeof($argList);

		if($argsize > 0){
			$paramList		= array();
			$paramsize		= substr_count($argList[0],"%");
			$propertiesize	= $argsize - 1;

			for($i=1;$i<$argsize;$i++){
				$paramList[] = $argList[$i];
			}			
			if($paramsize > $propertiesize){
				for($i=0;$i<$paramsize-$propertiesize;$i++){
					$paramList[] = "";
				}
			}
			return vsprintf($argList[0],$paramList);
		}
		return "";
	}
}	
?>