<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class DateUtil{
	function addDay($time,$day){
		$dateList	= getdate($time);

		return mktime($dateList["hours"],
						$dateList["minutes"],
						$dateList["seconds"],
						$dateList["mon"],
						$dateList["mday"] + $day,
						$dateList["year"]
					);
	}
	function addMonth($time,$month){
		$dateList	= getdate($time);

		return mktime($dateList["hours"],
						$dateList["minutes"],
						$dateList["seconds"],
						$dateList["mon"] + $month,
						$dateList["mday"],
						$dateList["year"]
					);

	}
	function addMinutes($time,$minute){
		$dateList	= getdate($time);

		return mktime($dateList["hours"],
						$dateList["minutes"] + $minute,
						$dateList["seconds"],
						$dateList["mon"],
						$dateList["mday"],
						$dateList["year"]
					);
	}

	function addTimestamp($time,$year=0,$month=0,$day=0,$hours=0,$minute=0,$seconds=0){
		$dateList	= getdate($time);

		return mktime($dateList["hours"] + $hours,
						$dateList["minutes"] + $minute,
						$dateList["seconds"] + $seconds,
						$dateList["mon"] + $month,
						$dateList["mday"] + $day,
						$dateList["year"] + $year
					);
	}

	function stringToTimestamp($str){
		$str		= preg_replace("/[\-\+\:\040\/]/","",$str);

		if(!empty($str) && $str > 0){
			$year	= substr($str,0,4);
			$month	= substr($str,4,2);
			$day	= substr($str,6,2);
			$hour	= substr($str,8,2);
			$min	= substr($str,10,2);
			$sec	= substr($str,12,2);

			return mktime($hour,$min,$sec,$month,$day,$year);
		}
		return getdate();
	}


	function timeToString($time){
		return date("Y/m/d H:i:s (D)",$time);
	}

	function simpleTimeToString($time){
		return date("Y-m-d H:i:s",$time);
	}

	function stringToSimpleTime($str){
		$str = preg_replace("/[\-\+\:\040\/]/","",$str);

		if(!empty($str) && $str > 0){
			$year	= substr($str,0,4);
			$month	= substr($str,4,2);
			$day	= substr($str,6,2);
			$hour	= substr($str,8,2);
			$min	= substr($str,10,2);
			$sec	= substr($str,12,2);

			return date("Y-m-d H:i:s",mktime($hour,$min,$sec,$month,$day,$year));
		}
		return;
	}

	function timestampToString($time){
		if(!empty($time)){
			return date("Y/m/d H:i:s (D)",$time);
		}
		return;
	}

	function simpleTimestampToString($time){
		if(!empty($time)){
			return date("Y-m-d H:i:s",$time);
		}
		return;
	}

	function getTimstampYear($time){
		return date("Y",$time);
	}

	function getTimstampMonth($time){
		return date("m",$time);
	}
	function getTimstampDay($time){
		return date("d",$time);
	}
}
?>