<?php
/**
 * @author Makoto Tsuyuki
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class ArrayUtils {
	/**
	 * 第一引数のarrayの第二引数num番目（0からスタート）の要素を配列から削除します。
	 * 第一引数のarrayは参照渡しとなることに注意してください。
	 * 戻り値は削除した値となります。
	 * また、arrayがnumより小さい場合にはnullを返します。
	 * arrayが数字の添え字が与えられたarrayでない場合（例えばhash）は、0から順に添え字が降られたarrayに置き換わります。
	 */
	function remove(&$array, $num) {
		if(count($array) <= $num) return null;
		$target = null;
		$result = array();
		$i = 0;
		foreach($array as $name => $value) {
			if($i == $num) $target = $value;
			else {
				$result[] = $value;
			}
			$i++;
		}
		$array = $result;
		return $target;
	}
	
	/**
	 * ArrayUtils::remove(&array, num)を使用して、特定の順序に割り当てられている値を配列の最後に移動します。
	 * arrayが数字の添え字が与えられたarrayでない場合（例えばhash）は、0から順に添え字が降られたarrayに置き換わります。
	 * 戻り値はありません。
	 * @see this->remove(&array, num)
	 */
	function moveToLast(&$array, $num) {
		$target = ArrayUtils::remove($array, $num);
		if($target == null) return ;
		$array[] = $target;
	}
}
?>