<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class ExceptionBase{
	var $value			= "";
	var $message			= "";
	var $target			= "";
	var $properties		= array();
		
	function ExceptionBase($target,$value="",$properties=array()){
		if(is_object($target)){
			$this->target = get_class($target);
		}else{
			$this->target	= $target;
		}		
		$this->value			= $value;
		$this->properties	= $properties;
	}
	function toString(){
		return sprintf("[%s][%s]%s",$this->target,get_class($this),$this->value);		
	}
	function getMessage(){
		$argsize		= substr_count($this->message,"%");
		$propertiesize	= sizeof($this->properties);
		
		if($argsize > $propertiesize){
			for($i=0;$i<$argsize-$propertiesize;$i++){
				$this->properties[] = "";
			}
		}		
		return vsprintf($this->message,$this->properties);
	}
}
?>