<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ExceptionBase.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.1
 */
class ExceptionTrigger{
	function fatal($exception){
		if(!isset($GLOBALS["EXCEPTION"])){
			$GLOBALS["EXCEPTION"] = array();			
		}
		if(is_subclass_of($exception,"ExceptionBase")){
			if(!is_array($GLOBALS["EXCEPTION"]["FATAL"])){
				$GLOBALS["EXCEPTION"]["FATAL"] = array();
			}
			$GLOBALS["EXCEPTION"]["FATAL"][] = $exception;

			$report = ini_get("display_errors");
			ini_set("display_errors",false);
			trigger_error($exception->getMessage(),E_USER_ERROR);
			ini_set("display_errors",$report);
		}
	}	
	function error($exception){
		if(!isset($GLOBALS["EXCEPTION"])){
			$GLOBALS["EXCEPTION"] = array();			
		}		
		if(is_subclass_of($exception,"ExceptionBase")){
			if(!is_array($GLOBALS["EXCEPTION"]["ERROR"])){
				$GLOBALS["EXCEPTION"]["ERROR"] = array();
			}
			$GLOBALS["EXCEPTION"]["ERROR"][] = $exception;
			
			$report = ini_get("display_errors");
			ini_set("display_errors",false);
			trigger_error($exception->getMessage(),E_USER_WARNING);
			ini_set("display_errors",$report);		
		}
	}
	function note($exception){
		if(!isset($GLOBALS["EXCEPTION"])){
			$GLOBALS["EXCEPTION"] = array();			
		}		
		if(is_subclass_of($exception,"ExceptionBase")){
			if(!is_array($GLOBALS["EXCEPTION"]["NOTE"])){
				$GLOBALS["EXCEPTION"]["NOTE"] = array();
			}			
			$GLOBALS["EXCEPTION"]["NOTE"][] = $exception;
			
			$report = ini_get("display_errors");
			ini_set("display_errors",false);
			trigger_error($exception->getMessage(),E_USER_NOTICE);
			ini_set("display_errors",$report);		
		}
	}
	
	function isFatal($object=null){
		if(isset($GLOBALS["EXCEPTION"]["FATAL"]) && sizeof($GLOBALS["EXCEPTION"]["FATAL"]) > 0){
			if(!is_object($object)){
				return true;
			}
			foreach($GLOBALS["EXCEPTION"]["FATAL"] as $exception){
				if(preg_match("/^".get_class($object)."$/i",get_class($exception))){
					return true;
				}
			}
		}
		return false;
	}
	
	function isError($object=null){
		if(isset($GLOBALS["EXCEPTION"]["ERROR"]) && sizeof($GLOBALS["EXCEPTION"]["ERROR"]) > 0){
			if(!is_object($object)){
				return true;
			}
			foreach($GLOBALS["EXCEPTION"]["ERROR"] as $exception){
				if(preg_match("/^".get_class($object)."$/i",get_class($exception))){
					return true;
				}
			}
		}
		return false;
	}
	function isNotice($object=null){
		if(isset($GLOBALS["EXCEPTION"]["NOTE"]) && sizeof($GLOBALS["EXCEPTION"]["NOTE"]) > 0){
			if(!is_object($object)){
				return true;
			}
			foreach($GLOBALS["EXCEPTION"]["NOTE"] as $exception){
				if(preg_match("/^".get_class($object)."$/i",get_class($exception))){
					return true;
				}
			}
		}
		return false;
	}
	
	function getFatal(){
		if(is_array($GLOBALS["EXCEPTION"]["FATAL"])){
			return $GLOBALS["EXCEPTION"]["FATAL"];
		}
		return array();
	}
	function getErrors(){
		if(is_array($GLOBALS["EXCEPTION"]["ERROR"])){
			return $GLOBALS["EXCEPTION"]["ERROR"];
		}
		return array();		
	}
	function getNote(){
		if(is_array($GLOBALS["EXCEPTION"]["NOTE"])){
			return $GLOBALS["EXCEPTION"]["NOTE"];
		}
		return array();
	}

	function clear() {
		$GLOBALS["EXCEPTION"]["FATAL"] = array();
		$GLOBALS["EXCEPTION"]["ERROR"] = array();
		$GLOBALS["EXCEPTION"]["NOTE"]  = array();
	}
}
?>