<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/CriteriaPattern.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.7.1
 */
class Criteria{
	var $criteriaList					= array();	
	var $criteriaPatternColumnValueList	= array();
	var $criteriaPatternColumnColumnList	= array();
	var $orderList						= array();
	var $limit		= null;
	var $offset		= null;
	var $lock		= null;
	var $distinct	= null;
	
	function Criteria(){
	}
	function addOrder($column){
		if(!preg_match("/Column/i",get_class($column))){
			ExceptionTrigger::error(new ClassTypeException($this));	
			return false;
		}
		$this->orderList[] = new CriteriaPattern($column,null,1);
		return true;
	}
	function addOrderDesc($column){
		if(!preg_match("/Column/i",get_class($column))){
			ExceptionTrigger::error(new ClassTypeException($this));	
			return false;
		}
		$this->orderList[] = new CriteriaPattern($column,null,2);
		return true;
	}
	function setPager($pager){		
		if(preg_match("/Pager/i",get_class($pager))){
			$this->setLimit($pager->limit);
			$this->setOffset($pager->offset);
		}		
	}
	function setLimit($value){
		$this->limit = Variable::getInt($value);
	}
	function setOffset($value){
		$this->offset = Variable::getInt($value);
	}
	function setLock($value){
		$this->lock = Variable::getBoolean($value);
	}
	function isLimit(){
		return ($this->limit != null);
	}
	function isOffset(){
		return ($this->offset != null);
	}
	function isLock(){
		return ($this->lock != null);
	}
	function isDistinct(){
		return ($this->distinct != null);
	}
	function clear(){
		$this->criteriaList					= array();	
		$this->criteriaPatternColumnValueList	= array();
		$this->criteriaPatternColumnColumnList	= array();
		$this->orderList						= array();
		$this->limit							= null;
		$this->offset						= null;
		$this->lock							= null;
		$this->distinct						= null;
	}

	function addDistinct($column){
		if(!preg_match("/Column/i",get_class($column))){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;
		}
		$this->distinct = $column;
		return true;		
	}
	function addCriteria($criteria){
		return $this->_addCriteria($criteria,1);
	}
	function addCriteriaOr($criteria){
		return $this->_addCriteria($criteria,2);
	}

	function add($columnOrValueA,$columnOrValueB){
		return $this->addEqual($columnOrValueA,$columnOrValueB);
	}
	function addEqual($columnOrValueA,$columnOrValueB){
		return $this->_add($columnOrValueA,$columnOrValueB,1);
	}
	function addNotEqual($columnOrValueA,$columnOrValueB){
		return $this->_add($columnOrValueA,$columnOrValueB,2);
	}
	function addGreater($columnOrValueA,$columnOrValueB){
		return $this->_add($columnOrValueA,$columnOrValueB,3);
	}
	function addGreaterEquals($columnOrValueA,$columnOrValueB){
		return $this->_add($columnOrValueA,$columnOrValueB,4);
	}	
	function addLess($columnOrValueA,$columnOrValueB){
		return $this->_add($columnOrValueA,$columnOrValueB,5);
	}
	function addLessEquals($columnOrValueA,$columnOrValueB){
		return $this->_add($columnOrValueA,$columnOrValueB,6);
	}
	function addLike($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;			
		}
		return $this->_add($columnOrValueA,$columnOrValueB,7);
	}
	function addIn($columnOrValueA,$columnOrValueB){
		if(!is_array($columnOrValueB) || sizeof($columnOrValueB) <= 0){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;
		}
		return $this->_add($columnOrValueA,$columnOrValueB,8);
	}
	function addNotLike($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;			
		}
		return $this->_add($columnOrValueA,$columnOrValueB,9);
	}
	function addNotIn($columnOrValueA,$columnOrValueB){
		if(!is_array($columnOrValueB) || sizeof($columnOrValueB) <= 0){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;
		}
		return $this->_add($columnOrValueA,$columnOrValueB,10);
	}
	
	function _addCriteria($criteria,$pattern=1){
		if(!preg_match("/Criteria/i",get_class($criteria))){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;
		}
		$this->criteriaList[] = new CriteriaPattern($criteria,null,$pattern);

		return true;
	}
	function _add($columnOrValueA,$columnOrValueB,$pattern=1){
		if(!preg_match("/Column/i",get_class($columnOrValueA))){
			ExceptionTrigger::error(new ClassTypeException($this));			
			return false;
		}
		if(preg_match("/Column/i",get_class($columnOrValueB))){
			$this->criteriaPatternColumnColumnList[] = new CriteriaPattern($columnOrValueA,$columnOrValueB,$pattern);
		}else{
			$this->criteriaPatternColumnValueList[] = new CriteriaPattern($columnOrValueA,$columnOrValueB,$pattern);
		}
		return true;
	}
	function __tables(){
		$tables = array();

		foreach($this->criteriaPatternColumnColumnList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;
			$tables[$criteriaPattern->columnOrValueB->table->alias][$criteriaPattern->columnOrValueB->column] = $criteriaPattern->columnOrValueB;
		}
		foreach($this->criteriaPatternColumnValueList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;			
		}
		foreach($this->criteriaList as $criteria){
			$tables = array_merge($tables,$criteria->columnOrValueA->__tables());
		}
		return $tables;
	}
}
?>