<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class ExtDbUtil extends DbUtil{
	function ExtDbUtil($DbConnection,$open=true){
		$this->Logger = new Logger($this);		
		$this->_setDatabase($DbConnection->type);
		
		if($this->database == "MYSQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilMySQL.php")){
				$this->dbUtil = new ExtDbUtilMySQL();
			}
		}else if($this->database == "POSTGRESQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilPostgreSQL.php")){
				$this->dbUtil = new ExtDbUtilPostgreSQL();
			}
		}
		if($this->dbUtil == null){
			ExceptionTrigger::error(new NotSupportedException($this,"Import Error"));	
			return false;
		}
		if($open){
			return $this->_open($DbConnection);
		}
		return true;
	}
	function forward($databaseObject){
		if($this->dbUtil != null){
			return $this->dbUtil->forward($databaseObject);
		}
		return false;
	}
}
?>