<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criteria.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.3
 */
class DbUtilPostgreSQL{
	var $Logger			= null;	
	var $resourceId		= false;
	var $connection		= false;
	var $dbConnection	= null;
	
	function DbUtilPostgreSQL(){
		$this->Logger = new Logger($this);
	}
	
	function open($dbConnection){
		if(extension_loaded("pgsql")){
			$con = sprintf("dbname=%s",$dbConnection->name);
	
			if($dbConnection->host != ""){		$con .= sprintf(" host=%s",$dbConnection->host);			}
			if($dbConnection->port != ""){		$con .= sprintf(" port=%s",$dbConnection->port);			}
			if($dbConnection->user != ""){		$con .= sprintf(" user=%s",$dbConnection->user);			}
			if($dbConnection->password != ""){	$con .= sprintf(" password=%s",$dbConnection->password);	}

			$this->connection = @pg_connect($con);

			if($this->connection != false){
				if($dbConnection->encode != ""){
					if(!@pg_set_client_encoding($this->connection,$this->encode)){
						$this->connection = false;
						return false;
					}
				}
				$this->dbConnection = $dbConnection;
				$this->_begin();
				return true;
			}
		}
		return false;
	}
	function close(){
		$this->_commit();
		@pg_close($this->connection);
	}
	function query($sql){
		$this->Logger->debug($sql);

		$this->resourceId	= @pg_query($this->connection,$sql);
		$error				= pg_last_error($this->connection);

		if(!empty($error)){
			$this->Logger->error($error);
			return false;	
		}
		return true;
	}
	function resultset(){
		if($this->resourceId != false){
			return pg_fetch_array($this->resourceId);
		}
		return array();
	}
	function free(){
		if($this->resourceId != false){
			pg_free_result($this->resourceId);
		}
	}
	function commit(){
		$this->_commit();
		$this->_begin();
	}
	function rollback(){
		$this->query("ROLLBACK");
	}
	function _begin(){
		$this->query("BEGIN");
	}
	function _commit(){
		$this->query("COMMIT");
	}
	function parseResultset($resultset){
		$list	= array();
		$count	= 0;		
		
		foreach($resultset as $key => $value){
			if($count % 2 == 1){
				$list[strtoupper($key)] = Variable::getMagicQuotesOffValue($value);
			}
			$count++;
		}
		return $list;
	}
	function select($tableObject,$criteria){
		$distinctString	= "";
		$columnString	= "";
		$tableString		= "";
		$orderString		= "";
		$sql				= "";
		$columnList		= array();
		$tableList		= array();

		if($criteria->isDistinct()){
			$distinctString = sprintf(" DISTINCT(%s.%s),",$criteria->distinct->table->alias,$criteria->distinct->column);
			$tableList[$criteria->distinct->table->alias]	= $criteria->distinct->table;
		}
		foreach($criteria->__tables() as $columnObjectList){
			foreach($columnObjectList as $columnObject){
				$tableList[$columnObject->table->alias]	= $columnObject->table;
			}
		}
		foreach($criteria->orderList as $criteriaPattern){
			$pattern = "ASC";
			
			if($criteriaPattern->pattern == 2){
				$pattern = "DESC";
			}
			$orderString .= sprintf(",%s.%s %s",
										$criteriaPattern->columnOrValueA->table->alias,
										$criteriaPattern->columnOrValueA->column,
										$pattern
								);
		}
		foreach($tableObject->__columns() as $columnObject){
			$bool = true;
			
			if($criteria->isDistinct()){
				if($columnObject->column == $criteria->distinct->column &&
					$columnObject->table->alias == $criteria->distinct->table->alias
				){
					$bool = false;
				}
			}
			if($bool){
				$columnList[$columnObject->column]	= $columnObject;
			}
			$tableList[$columnObject->table->alias]	= $columnObject->table;
		}
		foreach($columnList as $column){
			if($column->type == "TIMESTAMP"){
				$columnString .= sprintf("to_char(%s.%s,'YYYY/MM/DD HH24:MI:SS') as %s,",$column->table->alias,$column->column,$column->column);				
			}else{
				$columnString .= sprintf("%s.%s,",$column->table->alias,$column->column);
			}
		}
		foreach($tableList as $table){
			$tableString .= sprintf("%s %s,",$table->name,$table->alias);
		}
		$sql = sprintf("select %s%s from %s %s",
						$distinctString,substr($columnString,0,-1),
						substr($tableString,0,-1),
						$this->_getWhere($this->_getWhereSelect($criteria))
				);
		if(!empty($orderString)){
			$sql .= sprintf(" ORDER BY %s",substr($orderString,1));
		}
		if($criteria->isLimit()){
			$sql .= sprintf(" OFFSET %d LIMIT %d ",$criteria->offset,$criteria->limit);
		}
		if($criteria->isLock()){
			$sql .= " FOR UPDATE";	
		}
		return $this->query($sql);
	}
	function count($tableObject,$criteria){
		$countString		= "";
		$tableString		= "";
		$sql				= "";
		$tableList		= array();
		
		if($criteria->isDistinct()){
			$countString = sprintf(" DISTINCT(%s.%s) ",$criteria->distinct->table->alias,$criteria->distinct->column);
			$tableList[$criteria->distinct->table->alias]	= $criteria->distinct->table;
		}
		foreach($criteria->__tables() as $columnObjectList){
			foreach($columnObjectList as $columnObject){
				$tableList[$columnObject->table->alias]	= $columnObject->table;
			}
		}		
		if(empty($countString)){
			foreach($tableObject->__columns() as $columnObject){
				$countString = sprintf("%s.%s",$columnObject->table->alias,$columnObject->column);
				$tableList[$columnObject->table->alias]	= $columnObject->table;
				break;
			}
		}
		foreach($tableList as $table){
			$tableString .= sprintf("%s %s,",$table->name,$table->alias);
		}
		$sql = sprintf("select COUNT(%s) as count from %s %s",
					$countString,
					substr($tableString,0,-1),
					$this->_getWhere($this->_getWhereSelect($criteria))
				);

		if($this->query($sql)){
			$resultset = $this->resultset();	
			$this->free();
			return $resultset["count"];
		}
		return 0;
	}
	function insert($tableObject){
		$columnString	= "";
		$tableString		= "";
		$valueString		= "";
		$sql				= "";

		if(!$tableObject->__isTable()){
			return false;
		}
		foreach($tableObject->__columns() as $columnObject){
			if($columnObject->type != "SERIAL"){
				$columnString	.= sprintf(",%s",$columnObject->column);
				$valueString		.= sprintf(",%s",$this->_getColumnValueString($tableObject,$columnObject));
				$tableString		= $columnObject->table->name;
			}
		}
		$sql = sprintf("insert into %s(%s) values(%s)",$tableString,substr($columnString,1),substr($valueString,1));		
		
		if($this->query($sql)){
			$lastId		= $this->_insertId($tableObject);
			$pkeyList	= $tableObject->__primaryKey();
			
			if(intval($lastId) > 0 && sizeof($pkeyList) == 1){
				foreach($pkeyList as $column){
					call_user_func_array(array(&$tableObject,sprintf("set%s",$column->variable)),array($lastId));
				}
			}
			return $tableObject;
		}
		return false;
	}

	function _insertId($tableObject){
		foreach($tableObject->__primaryKey() as $pkeyColumn){
			if($this->query(sprintf("select last_value from %s_%s_seq",$pkeyColumn->table->name,$pkeyColumn->column))){
				$resultset = $this->resultset();	
				$this->free();
				return $resultset["last_value"];
			}
		}
		return 0;
	}
	
	function update($tableObject,$criteria){
		$columnString	= "";
		$tableString		= "";
		$sql				= "";
		$primaryList	= array();

		if(!$tableObject->__isTable()){
			return false;
		}
		foreach($tableObject->__primaryKey() as $columnObject){
			$primaryList[sprintf("%s_%s",$columnObject->table->name,$columnObject->column)] = $columnObject;
		}			
		foreach($tableObject->__columns() as $columnObject){
			if(empty($primaryList[sprintf("%s_%s",$columnObject->table->name,$columnObject->column)])){			
				$columnString	.= sprintf(",%s = %s",$columnObject->column,$this->_getColumnValueString($tableObject,$columnObject));
				$tableString		= $columnObject->table->name;
			}
		}

		$sql = sprintf("update %s set %s %s",
									$tableString,
									substr($columnString,1),
									$this->_getWhere($this->_getWhereUpdate($tableObject,$criteria))
				);
		return $this->query($sql);
	}
	function delete($tableObject,$criteria){
		$tableString		= "";
		$sql				= "";

		if(!$tableObject->__isTable()){
			return false;
		}
		foreach($tableObject->__columns() as $columnObject){
			$tableString		= $columnObject->table->name;
			break;
		}
		$sql = sprintf("delete from %s %s",$tableString,$this->_getWhere($this->_getWhereUpdate($tableObject,$criteria)));
		
		return $this->query($sql);
	}

	function _getCriteriaPatternString($pattern){
		switch($pattern){
			case 1:	return " = ";
			case 2:	return " <> ";
			case 3:	return " > ";
			case 4:	return " >= ";
			case 5:	return " < ";
			case 6:	return " <= ";
		}
		return "";
	}
	function _getWhere($whereString){
		if(!empty($whereString)){
			if(preg_match("/^ AND(.+)$/",$whereString,$value)){
				$whereString = $value[1];
			}
			return sprintf(" where %s",$whereString);
		}
		return "";
	}
	function _getWhereSelect($criteria){
		$whereString = "";

		foreach($criteria->criteriaPatternColumnValueList as $criteriaPattern){
			if($criteriaPattern->pattern <= 6){
				$whereString .= sprintf(" AND %s.%s %s %s ",
										$criteriaPattern->columnOrValueA->table->alias,
										$criteriaPattern->columnOrValueA->column,
										$this->_getCriteriaPatternString($criteriaPattern->pattern),
										$this->_getValueString($criteriaPattern->columnOrValueA,$criteriaPattern->columnOrValueB)
								);
			}else if($criteriaPattern->pattern == 7 || $criteriaPattern->pattern == 9){
				$whereString .= sprintf(" AND %s.%s %s LIKE('%s') ",
											$criteriaPattern->columnOrValueA->table->alias,
											$criteriaPattern->columnOrValueA->column,
											(($criteriaPattern->pattern == 9)?"not":""),
											str_replace(".","_",str_replace(".*","%",$criteriaPattern->columnOrValueB))
									);
			}else if($criteriaPattern->pattern == 8 || $criteriaPattern->pattern == 10){
				$inString	= "";

				foreach($criteriaPattern->columnOrValueB as $value){
					$inString .= sprintf(",%s",$this->_getValueString($criteriaPattern->columnOrValueA,$value));
				}
				$whereString .= sprintf(" AND %s.%s %s in(%s) ",
											$criteriaPattern->columnOrValueA->table->alias,
											$criteriaPattern->columnOrValueA->column,
											(($criteriaPattern->pattern == 10)?"not":""),
											substr($inString,1)
									);
			}
		}
		foreach($criteria->criteriaPatternColumnColumnList as $criteriaPattern){
			$whereString .= sprintf(" AND %s.%s %s %s.%s ",
										$criteriaPattern->columnOrValueA->table->alias,
										$criteriaPattern->columnOrValueA->column,
										$this->_getCriteriaPatternString($criteriaPattern->pattern),
										$criteriaPattern->columnOrValueB->table->alias,
										$criteriaPattern->columnOrValueB->column
								);
		}
		foreach($criteria->criteriaList as $criteriaObject){
			$pattern		= "AND";
			$where		= $this->_getWhereSelect($criteriaObject->columnOrValueA);

			if($criteriaObject->pattern == 2){
				$pattern = "OR";
			}			
			if(preg_match("/^ AND(.+)$/",$where,$value)){
				$where = $value[1];
			}
			if(!empty($where)){
				if(empty($whereString)){
					$pattern = "";
				}
				$whereString .= sprintf(" %s (%s) ",$pattern,$where);
			}
		}
		return $whereString;
	}
	function _getWhereUpdate($tableObject,$criteria){
		$whereString = "";
		$tableString = "";

		foreach($tableObject->__columns() as $columnObject){
			$tableString	= $columnObject->table->name;
			break;
		}
		foreach($criteria->criteriaPatternColumnValueList as $criteriaPattern){
			if($criteriaPattern->columnOrValueA->table->name == $tableString){
				if($criteriaPattern->pattern <= 6){
					$whereString .= sprintf(" AND %s %s %s ",
											$criteriaPattern->columnOrValueA->column,
											$this->_getCriteriaPatternString($criteriaPattern->pattern),
											$this->_getValueString($criteriaPattern->columnOrValueA, $criteriaPattern->columnOrValueB)
									);
				}else if($criteriaPattern->pattern == 7){
					$whereString .= sprintf(" AND %s LIKE('%s') ",
												$criteriaPattern->columnOrValueA->column,
												str_replace(".","_",str_replace(".*","%",$criteriaPattern->columnOrValueB))
										);
				}else if($criteriaPattern->pattern == 8){
					$inString = "";
	
					foreach($criteriaPattern->columnOrValueB as $value){
						$inString .= sprintf(",%s",$this->_getValueString($criteriaPattern->columnOrValueA,$value));
					}
					$whereString .= sprintf(" AND %s.%s in(%s) ",
												$criteriaPattern->columnOrValueA->column,
												substr($inString,1)
										);
				}
			}
		}
		return $whereString;
	}
	function _getColumnValueString($tableObject,$column){
		$value = call_user_func_array(array($tableObject,sprintf("get%s",$column->variable)),array());

		return $this->_getValueString($column,$value);
	}
	function _getValueString($column,$value){
		if($value != ""){
			$value = $this->_escape($value);

			switch(strtoupper($column->type)){
				case "STRING":
					return sprintf("'%s'",$value);
				case "INTEGER":
				case "SERIAL":
					return intval($value);
				case "TIMESTAMP":
					return sprintf("to_timestamp('%s','YYYY-MM-DD HH24:MI:SS')",DateUtil::simpleTimeToString($value));
				case "BOOLEAN":
					return sprintf("'B%s'",intval(Variable::getBoolean($value)));
				default:
			}
		}
		return "NULL";		
	}
	function _escape($value){
		if(extension_loaded("pgsql")){
			return pg_escape_string($value);
		}
		return addslashes($value);
	}
}
?>