<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotSupportedException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalStateException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criteria.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.1
 */
class DbUtil{
	var $Logger			= null;	
	var $connection		= false;
	var $resultset		= array();
	var $dbUtil			= null;
	
	function DbUtil($DbConnection){
		$this->Logger = new Logger($this);		
		$this->_setDatabase($DbConnection->type);
		
		if($this->database == "MYSQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilMySQL.php")){
				$this->dbUtil = new DbUtilMySQL();
			}
		}else if($this->database == "POSTGRESQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilPostgreSQL.php")){
				$this->dbUtil = new DbUtilPostgreSQL();
			}
		}
		if($this->dbUtil == null){
			$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_IMPORT"]);
			ExceptionTrigger::error(new NotSupportedException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_IMPORT"]));
			return false;
		}
		return $this->_open($DbConnection);
	}
	function _open($DbConnection){
		if(!$this->connection){
			$this->close();
		}
		$this->connection = $this->dbUtil->open($DbConnection);

		if($this->connection){
			register_shutdown_function(array($this,'commit'));
			register_shutdown_function(array($this,'close'));
			return true;
		}
		$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_CONNECTION"]);
		ExceptionTrigger::error(new NotSupportedException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_CONNECTION"]));
		return false;
	}
	function close(){
		if($this->connection){
			$this->dbUtil->close();
			$this->connection = false;
		}
	}
	function commit(){
		if($this->connection){
			$this->dbUtil->commit();
		}
	}
	function rollback(){
		if($this->connection){
			$this->dbUtil->rollback();
		}
	}
	function query($sql){
		if($this->connection){
			$this->Logger->debug($sql);
			
			if(!$this->dbUtil->query($sql)){
				return false;
			}
		}
		return true;
	}
	function select($tableObject,$criteria=null){
		if($this->connection){
			if(is_subclass_of($tableObject,"TableObjectBase")){
				if(!empty($criteria)){
					if(!preg_match("/Criteria/i",get_class($criteria))){
						$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]);
						ExceptionTrigger::error(new ClassTypeException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]));
						return false;
					}
				}else{
					$criteria = new Criteria();
				}
				$this->dbUtil->select($tableObject,$criteria);

				return $this->_getResultsetToObject($tableObject);
			}
		}
		return false;
	}
	function count($tableObject,$criteria=null){
		if($this->connection){
			if(is_subclass_of($tableObject,"TableObjectBase")){
				if($criteria != null){
					if(!preg_match("/Criteria/i",get_class($criteria))){
						$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]);
						ExceptionTrigger::error(new ClassTypeException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]));
						return false;
					}
				}else{
					$criteria = new Criteria();
				}
				return $this->dbUtil->count($tableObject,$criteria);
			}
		}
		return 0;
	}
	function get($tableObject,$criteria=null){
		if($this->connection){
			if($criteria != null){
				if(!preg_match("/Criteria/i",get_class($criteria))){
					$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]);
					ExceptionTrigger::error(new ClassTypeException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]));

					return false;
				}
			}else{
				$criteria		= new Criteria();
				$primaryList		= $tableObject->__primaryKey();
				
				if(sizeof($primaryList) > 0){
					foreach($primaryList as $column){
						$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
	
						if(empty($value)){
							ExceptionTrigger::error(new IllegalStateException($this));
						}
						$criteria->add($column,$value);
					}
				}else{
					foreach($tableObject->__columns() as $column){
						$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
						$criteria->add($column,$value);
					}
				}
			}
			$criteria->setOffset(0);
			$criteria->setLimit(1);
			$list = $this->select($tableObject,$criteria);
			
			if(sizeof($list) > 0){
				return $list[0];
			}
		}
		return false;
	}
	function insert($tableObject){
		if($this->connection){
			if(is_subclass_of($tableObject,"TableObjectBase")){
				if(!$tableObject->__verify()){
					return false;
				}
				return $this->dbUtil->insert($tableObject);
			}
		}
		$this->rollback();
		return false;
	}
	function delete($tableObject,$criteria=null){
		if($this->connection){
			if(is_subclass_of($tableObject,"TableObjectBase")){
				if($criteria != null){
					if(!preg_match("/Criteria/i",get_class($criteria))){
						$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]);				
						ExceptionTrigger::error(new ClassTypeException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]));
						return false;
					}
				}else{
					$criteria = new Criteria();

					foreach($tableObject->__primaryKey() as $column){
						$value = call_user_func_array(array($tableObject,sprintf("get%s",$column->variable)),array());
						
						if(empty($value)){
							ExceptionTrigger::error(new IllegalStateException($this));
						}
						$criteria->add($column,$value);
					}
				}
				if($this->dbUtil->delete($tableObject,$criteria)){
					return true;
				}
			}
		}
		$this->rollback();
		return false;
	}
	function update($tableObject,$criteria=null){
		if($this->connection){
			if(is_subclass_of($tableObject,"TableObjectBase")){
				if($criteria != null){
					if(!preg_match("/Criteria/i",get_class($criteria))){
						$this->Logger->error($GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]);
						ExceptionTrigger::error(new ClassTypeException($this,$GLOBALS["RESOURCE"]["FAIL"]["DB_SELECT_ARG_TYPE"]));
						return false;
					}
				}else{
					$criteria = new Criteria();
	
					foreach($tableObject->__primaryKey() as $column){
						$value = call_user_func_array(array($tableObject,sprintf("get%s",$column->variable)),array());
						
						if(empty($value)){
							ExceptionTrigger::error(new IllegalStateException($this));
						}
						$criteria->add($column,$value);
					}
				}
				if(!$tableObject->__verify()){
					return false;
				}
				if($this->dbUtil->update($tableObject,$criteria)){
					return true;
				}
			}
		}
		$this->rollback();
		return false;
	}
	function next(){
		if($this->connection){
			$this->resultset = array();
			$resultset		= $this->dbUtil->resultset();
				
			if(!$resultset){
				$this->dbUtil->free();
				return false;
			}
			$this->resultset = $this->dbUtil->parseResultset($resultset);
			return true;
		}
		return false;
	}
	function getResultset(){
		return $this->resultset;
	}

	function _getResultsetToObject($tableObject){
		if(is_subclass_of($tableObject,"TableObjectBase")){
			$objectList	= array();
			$setter		= array();
			$columns		= $tableObject->__columns();

			for($i=0;$i<sizeof($columns);$i++){
				$setter[$columns[$i]->column] = sprintf("set%s",$columns[$i]->variable);
			}
			while($this->next()){
				$newobject = Variable::copy($tableObject);

				foreach($this->getResultset() as $key => $value){
					$value = Variable::getMagicQuotesOffValue($value);
					call_user_func_array(array(&$newobject,$setter[$key]),array($value));
				}
				$objectList[] = $newobject;
				unset($newobject);
			}
		}
		return $objectList;
	}
	function _setDatabase($database){
		if(preg_match("/(postgre)|(psql)/i",$database)){
			$this->database = "POSTGRESQL";
		}else if(preg_match("/my/i",$database)){
			$this->database = "MYSQL";
		}
	}
}
?>