<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.3.1
 */
class Rhaco{
	function defineTemplateUrl($url){
		if(!preg_match("/.+[\/\\\\]$/",$url)){
			$url = $url."/";
		}
		return Rhaco::define("TEMPLATE_URL",$url);
	}
	function defineTemplatePath($base,$path=""){
		return Rhaco::define("TEMPLATE_PATH",Rhaco::getFilePath($base,$path));
	}
	function defineTemplateCashPath($base,$path=""){
		return Rhaco::define("TEMPLATE_CASH_PATH",Rhaco::getFilePath($base,$path));
	}
	function defineTemplateCash($bool){
		return Rhaco::define("TEMPLATE_CASH",$bool);
	}
	
	function defineLogSysLevel($logType){
		return Rhaco::define("LOG_SYS_LEVEL",$logType);
	}
	function defineLogDispLevel($logType){
		return Rhaco::define("LOG_DISP_LEVEL",$logType);
	}
	function defineLogFileLevel($logType){
		return Rhaco::define("LOG_FILE_LEVEL",$logType);
	}
	function defineLogHtml($bool){
		return Rhaco::define("LOG_DISP_HTML",$bool);
	}	
	function defineLogFilePath($base,$path=""){
		return Rhaco::define("LOG_FILE_PATH",Rhaco::getFilePath($base,$path));
	}
	
	function defineContextRoot($path){
		return Rhaco::define("CONTEXT_ROOT",Rhaco::getFilePath($path));
	}
	function defineWebapp($path){
		return Rhaco::define("WEBAPP_PATH",Rhaco::getFilePath($path));
	}
	function defineContextUrl($url){
		return Rhaco::define("CONTEXT_URL",Rhaco::getFilePath($url));
	}
	function defineLibraryPath($path=""){
		if(!defined("LIBRARY_PATH")){
			if(empty($path)){
				$path = Rhaco::getDefinePath("CONTEXT_ROOT");
				$path .= "library/";
			}
			define("LIBRARY_PATH",Rhaco::getFilePath($path));
		}
	}

	function define($defineName,$value){
		if(!defined($defineName)){
			define($defineName,$value);
		}
		return constant($defineName);
	}

	function getFilePath($base,$path=""){
		$null = null;
		$base = preg_replace("/[\/\/]/","/",str_replace("\\","/",$base));
		$path = preg_replace("/[\/\/]/","/",str_replace("\\","/",$path));

		if(preg_match("/[\/]$/",$base,$null)){
			$base = substr($base,0,-1);
		}
		if(preg_match("/^[\/]/",$path,$null)){
			$path = substr($path,1);
		}
		return sprintf("%s/%s",$base,$path);
	}
	function getDefinePath($name,$defaultPath=""){
		$path = str_replace("\\","/",$defaultPath);
		
		if(defined($name)){
			$path = str_replace("\\","/",constant($name));

			if(preg_match("/[^\/]$/",$path,$null)){
				$path = $path."/";
			}
		}
		return $path;
	}	
	function path($fileName=""){
		$path = Rhaco::getDefinePath("CONTEXT_ROOT");

		if(preg_match("/^\/.+/",$fileName)){
			$fileName = substr($fileName,1);
		}
		return sprintf("%s%s",$path,$fileName);
	}
	function webapp($fileName=""){
		$path = Rhaco::getDefinePath("WEBAPP_PATH");

		if(preg_match("/^\/.+/",$fileName)){
			$fileName = substr($fileName,1);
		}
		return sprintf("%s%s",$path,$fileName);
	}
	function url($url=""){
		if(defined("CONTEXT_URL")){
			$path = str_replace("\\","/",constant("CONTEXT_URL"));
		}else{
			$path = $_SERVER["HTTP_HOST"];
			
			if(preg_match("/\/([^\/])\/.+/",$_SERVER["REDIRECT_URL"],$null)){
				$path .= "/".$null[1];
			}
		}
		return sprintf("%s%s",Rhaco::_pathnormalize($path),Rhaco::_urlnormalize($url));
	}
	function templatepath($fileName=""){
		$path = Rhaco::getDefinePath("TEMPLATE_PATH");

		if(preg_match("/^\/.+/",$fileName)){
			$fileName = substr($fileName,1);
		}
		return sprintf("%s%s",$path,$fileName);
	}
	function templateurl($url=""){
		$path = "";

		if(defined("TEMPLATE_URL")){
			$path = str_replace("\\","/",constant("TEMPLATE_URL"));
		}else{
			$path = Rhaco::url("resources/templates");
		}
		return sprintf("%s%s",Rhaco::_pathnormalize($path),Rhaco::_urlnormalize($url));
	}
	function import($rhacoClassName){
		return require_once(Rhaco::_phppathnormalize(Rhaco::getDefinePath("RHACO_DIR"),$rhacoClassName));
	}
	function importLibrary($fileName){
		$path = "";

		if(defined("LIBRARY_PATH")){
			$path = Rhaco::getDefinePath("LIBRARY_PATH");
		}else{
			$path = Rhaco::getDefinePath("CONTEXT_ROOT");
			$path .= "library/";
		}
		return require_once(Rhaco::_phppathnormalize($path,$fileName));
	}
	function loadLibrary($fileName){
		$path = "";

		if(defined("LIBRARY_PATH") && !empty($fileName)){
			$path = Rhaco::getDefinePath("LIBRARY_PATH");
		}else{
			$path = Rhaco::getDefinePath("CONTEXT_ROOT");
			$path .= "library/";
		}
		return require(Rhaco::_phppathnormalize($path,$fileName));
	}
	function resource($resourceFileName){
		$path = "";
		
		if(defined("RHACO_DIR")){
			$path = str_replace("\\","/",constant("RHACO_DIR"));
			$path = Rhaco::_pathnormalize($path);

			if(preg_match("/^[^\/]/",$resourceFileName,$null)){
				$resourceFileName = "/".$resourceFileName;
			}
		}
		return sprintf("%sresources%s",$path,$resourceFileName);
	}
	function isException(){
		return !empty($GLOBALS["EXCEPTION"]);
	}
	function exceptions(){
		if(!is_array($GLOBALS["EXCEPTION"])){
			return array();
		}
		return $GLOBALS["EXCEPTION"];
	}
	function version(){
		return "0.7.1";
	}
	
	function _phppathnormalize($path,$fileName){
		if(preg_match("/^(.+)\.php$/",$fileName,$null)){
			$fileName = $null[1];
		}
		return sprintf("%s%s.php",$path,str_replace(".","/",$fileName));
	}
	function _pathnormalize($path){
		if(preg_match("/[^\/]$/",$path,$null)){
			$path = $path."/";
		}
		return $path;
	}
	function _urlnormalize($url){
		if(preg_match("/^\/.+/",$url)){
			$url = substr($url,1);
		}
		return $url;
	}
}
?>
<?php
if(!defined("RHACO_DIR")){
	Rhaco::define("RHACO_DIR",Rhaco::_pathnormalize(dirname(__FILE__)));	

	if(!empty($_SERVER["HTTP_ACCEPT_LANGUAGE"]) && preg_match("/(ja)|(jp)/i",$_SERVER["HTTP_ACCEPT_LANGUAGE"])){
		Rhaco::import("resources.Resource_JP");
	}else{
		Rhaco::import("resources.Resource_EN");
	}
}
?>