/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.action.task;

import net.yher2.workstyle.TaskQuery;
import net.yher2.workstyle.test.ActionFormTestCase;
import net.yher2.workstyle.torque.Status;

public class SearchFormTest extends ActionFormTestCase {
	private SearchForm form;
	protected void setUp() throws Exception {
		super.setUp();
		form = new SearchForm();
		form.reset(null, null);
	}

	public void testReset() {
		setValid();
		form.reset(null, null);
		assertDefault(form.getKeyword());
		assertEquals(form.getOrder(), TaskQuery.ORDER_BY_STATUS_ASC);
		assertDefault(form.getExcludeTag());
		assertDefault(form.getStatus());
		assertDefault(form.getTag());
	}

	public void testGetQuery() {
		setValid();
		TaskQuery query = form.getQuery();
		assertEquals(form.getKeyword(), query.getKeyword());
		assertEquals(form.getExcludeTag(), query.getExcludeTag());
		assertEquals(form.getOrder(), query.getOrder());
		assertEquals(form.getStatus(), query.getStatus());
		assertEquals(form.getTag(), query.getTag());
	}
	
	private void setValid() {
		form.setExcludeTag(new String[]{"tag1", "tag2"});
		form.setKeyword("keyword");
		form.setLimit(10);
		form.setOffset(100);
		form.setOrder(TaskQuery.ORDER_BY_DATE_ASC);
		form.setStatus(new int[]{Status.FINISHED});
		form.setTag(new String[]{"tag1", "tag2"});
	}

}
