
/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque.bean;

import java.io.Serializable;


            
/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jan 26 23:30:02 JST 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TaskRelationBean
 */
public abstract class BaseTaskRelationBean
    implements Serializable
{

    /**
     * whether the bean or its underlying object has changed
     * since last reading from the database
     */
    private boolean modified = true;

    /**
     * false if the underlying object has been read from the database,
     * true otherwise
     */
    private boolean isNew = true;

  
    /** The value for the srcTaskId field */
    private int srcTaskId;
  
    /** The value for the destTaskId field */
    private int destTaskId;


    /**
     * sets whether the bean exists in the database
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * returns whether the bean exists in the database
     */
    public boolean isNew()
    {
        return this.isNew;
    }

    /**
     * sets whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public void setModified(boolean isModified)
    {
        this.modified = isModified;
    }

    /**
     * returns whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public boolean isModified()
    {
        return this.modified;
    }


    /**
     * Get the SrcTaskId
     *
     * @return int
     */
    public int getSrcTaskId ()
    {
        return srcTaskId;
    }

    /**
     * Set the value of SrcTaskId
     *
     * @param v new value
     */
    public void setSrcTaskId(int v)
    {
  
        this.srcTaskId = v;
        setModified(true);

    }

    /**
     * Get the DestTaskId
     *
     * @return int
     */
    public int getDestTaskId ()
    {
        return destTaskId;
    }

    /**
     * Set the value of DestTaskId
     *
     * @param v new value
     */
    public void setDestTaskId(int v)
    {
  
        this.destTaskId = v;
        setModified(true);

    }

      
    
                  
    
        private TaskBean aTaskBean;

    /**
     * sets an associated TaskBean object
     *
     * @param v TaskBean
     */
    public void setTaskBean(TaskBean v)
    {
            if (v == null)
        {
                          setSrcTaskId( 0);
              }
        else
        {
            setSrcTaskId(v.getTaskId());
        }
            aTaskBean = v;
    }

                        
    /**
     * Get the associated TaskBean object
     *
     * @return the associated TaskBean object
     */
    public TaskBean getTaskBean()
    {
        return aTaskBean;
    }

  

        }
