package net.yher2.workstyle.action.tagType.rest;

import javax.servlet.http.HttpServletRequest;

import net.yher2.commons.struts.Validator;
import net.yher2.workstyle.Properties;
import net.yher2.workstyle.torque.TagType;
import net.yher2.workstyle.torque.bean.TagTypeBean;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class AddForm extends ActionForm {
	private String name;
	private int sortOrder;

	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		name = "";
		sortOrder = 0;
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyRequired(Properties.TAG_TYPE, name);
		validator.verifyMaxLength(Properties.TAG_TYPE, name, 50);
		return validator.getErrors();
	}
	
	protected TagTypeBean getTagTypeBean() {
		TagTypeBean bean = new TagTypeBean();
		bean.setName(getName());
		bean.setSortOrder(getSortOrder());
		bean.setStyleClass(TagType.DEFAULT_STYLE);
		return bean;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}
}
