/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class TaskQuery {
	public static final int ORDER_BY_STATUS_ASC = 1;
	public static final int ORDER_BY_STATUS_DESC = 2;
	public static final int ORDER_BY_ID_ASC = 3;
	public static final int ORDER_BY_ID_DESC = 4;
	public static final int ORDER_BY_MAN_HOUR_ASC = 5;
	public static final int ORDER_BY_MAN_HOUR_DESC = 6;
	public static final int ORDER_BY_DATE_ASC = 7;
	public static final int ORDER_BY_DATE_DESC = 8;
	
	private String keyword;
	private int status[] = new int[0];
	private String tag[] = new String[0];
	private String excludeTag[] = new String[0];
	private Date dateFrom;
	
	private int unlinkedTaskId = 0;
	
	private int order = ORDER_BY_STATUS_ASC;
	
	public boolean hasUnlinkedTaskId() {
		return unlinkedTaskId > 0;
	}
	public boolean hasKeyword() {
		return StringUtils.isNotBlank(getKeyword());
	}
	public boolean hasStatus() {
		return (status != null && status.length > 0);
	}
	public boolean hasStatus(int checkStatus) {
		if (status == null) return false;
		for (int stat : status) {
			if (stat == checkStatus) return true;
		}
		return false;
	}
	public boolean hasTag() {
		return (tag != null && tag.length > 0);
	}
	public boolean hasTag(String checkTag) {
		return hasTag(tag, checkTag);
	}
	public boolean hasExcludeTag() {
		return (excludeTag != null && excludeTag.length > 0);
	}
	public boolean hasExcludeTag(String checkTag) {
		return hasTag(excludeTag,  checkTag);
	}
	private boolean hasTag(String tagList[], String checkTag) {
		if (tagList == null) return false;
		for (String aTag : tagList) {
			if (StringUtils.equals(aTag, checkTag)) return true;
		}
		return false;
	}
	public boolean hasDateFrom() {
		return (getDateFrom() != null);
	}
	public boolean hasOrder(int checkOrder) {
		return (order == checkOrder);
	}
	public List<String> getKeywordAsList() {
		if (StringUtils.isBlank(getKeyword())) return new ArrayList<String>();
		String keywordArray[] = getKeyword().split("[ \t\r\n]");
		List<String> result = new ArrayList<String>();
		for (String word : keywordArray) {
			if (StringUtils.isNotBlank(word)) {
				result.add(word);
			}
		}
		return result;
	}
	public int getOrder() {
		return order;
	}
	public void setOrder(int order) {
		this.order = order;
	}
	public String getKeyword() {
		return keyword;
	}
	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}
	public int[] getStatus() {
		return status;
	}
	public void setStatus(int[] status) {
		this.status = status;
	}
	public String[] getTag() {
		return tag;
	}
	public void setTag(String[] tag) {
		this.tag = tag;
	}
	public void removeTag(String targetTag) {
		List<String> tmpList = new ArrayList<String>();
		for (String aTag : tag) {
			if (!StringUtils.equals(aTag, targetTag)) {
				tmpList.add(aTag);
			}
		}
		setTag(tmpList.toArray(new String[tmpList.size()]));
	}
	public Date getDateFrom() {
		return dateFrom;
	}
	public void setDateFrom(Date dateFrom) {
		this.dateFrom = dateFrom;
	}
	public String[] getExcludeTag() {
		return excludeTag;
	}
	public void setExcludeTag(String[] excludeTag) {
		this.excludeTag = excludeTag;
	}
	public int getUnlinkedTaskId() {
		return unlinkedTaskId;
	}
	public void setUnlinkedTaskId(int unlinkedTaskid) {
		this.unlinkedTaskId = unlinkedTaskid;
	}
}
