/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class Index {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$engine$database$model$Index == null ? (class$org$apache$torque$engine$database$model$Index = Index.class$("org.apache.torque.engine.database.model.Index")) : class$org$apache$torque$engine$database$model$Index));
    private String indexName;
    private Table parentTable;
    private List indexColumns = new ArrayList(3);
    static /* synthetic */ Class class$org$apache$torque$engine$database$model$Index;

    public Index() {
    }

    protected Index(Table table, List indexColumns) throws EngineException {
        this();
        this.setTable(table);
        if (!indexColumns.isEmpty()) {
            this.indexColumns = indexColumns;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created Index named " + this.getName() + " with " + indexColumns.size() + " columns"));
            }
        } else {
            throw new EngineException("Cannot create a new Index using an empty list Column object");
        }
    }

    public void loadFromXML(Attributes attrib) {
        this.indexName = attrib.getValue("name");
    }

    public boolean isUnique() {
        return false;
    }

    public String getName() {
        return this.indexName;
    }

    public void setName(String name) {
        this.indexName = name;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public void addColumn(Attributes attrib) {
        this.indexColumns.add(attrib.getValue("name"));
    }

    public String getColumnList() {
        return Column.makeList(this.getColumns());
    }

    public List getColumns() {
        return this.indexColumns;
    }

    protected List getColumnNames() {
        ArrayList<String> names = new ArrayList<String>(this.indexColumns.size() + 2);
        Iterator i = this.getColumns().iterator();
        while (i.hasNext()) {
            Column c = (Column)i.next();
            names.add(c.getName());
        }
        return names;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" <index name=\"").append(this.getName()).append("\"");
        result.append(">\n");
        for (int i = 0; i < this.indexColumns.size(); ++i) {
            result.append("  <index-column name=\"").append(this.indexColumns.get(i)).append("\"/>\n");
        }
        result.append(" </index>\n");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

