
/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


                    
/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Jan 07 21:20:48 GMT+09:00 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TaskBean
 */
public abstract class BaseTaskBean
    implements Serializable
{

    /**
     * whether the bean or its underlying object has changed
     * since last reading from the database
     */
    private boolean modified = true;

    /**
     * false if the underlying object has been read from the database,
     * true otherwise
     */
    private boolean isNew = true;

  
    /** The value for the taskId field */
    private int taskId;
  
    /** The value for the contents field */
    private String contents;
                          
    /** The value for the estimatedManHour field */
    private double estimatedManHour = 0;
  
    /** The value for the tagList field */
    private String tagList;
  
    /** The value for the updateDate field */
    private Date updateDate;
  
    /** The value for the statusId field */
    private int statusId;


    /**
     * sets whether the bean exists in the database
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * returns whether the bean exists in the database
     */
    public boolean isNew()
    {
        return this.isNew;
    }

    /**
     * sets whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public void setModified(boolean isModified)
    {
        this.modified = isModified;
    }

    /**
     * returns whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public boolean isModified()
    {
        return this.modified;
    }


    /**
     * Get the TaskId
     *
     * @return int
     */
    public int getTaskId ()
    {
        return taskId;
    }

    /**
     * Set the value of TaskId
     *
     * @param v new value
     */
    public void setTaskId(int v)
    {
  
        this.taskId = v;
        setModified(true);

    }

    /**
     * Get the Contents
     *
     * @return String
     */
    public String getContents ()
    {
        return contents;
    }

    /**
     * Set the value of Contents
     *
     * @param v new value
     */
    public void setContents(String v)
    {
  
        this.contents = v;
        setModified(true);

    }

    /**
     * Get the EstimatedManHour
     *
     * @return double
     */
    public double getEstimatedManHour ()
    {
        return estimatedManHour;
    }

    /**
     * Set the value of EstimatedManHour
     *
     * @param v new value
     */
    public void setEstimatedManHour(double v)
    {
  
        this.estimatedManHour = v;
        setModified(true);

    }

    /**
     * Get the TagList
     *
     * @return String
     */
    public String getTagList ()
    {
        return tagList;
    }

    /**
     * Set the value of TagList
     *
     * @param v new value
     */
    public void setTagList(String v)
    {
  
        this.tagList = v;
        setModified(true);

    }

    /**
     * Get the UpdateDate
     *
     * @return Date
     */
    public Date getUpdateDate ()
    {
        return updateDate;
    }

    /**
     * Set the value of UpdateDate
     *
     * @param v new value
     */
    public void setUpdateDate(Date v)
    {
  
        this.updateDate = v;
        setModified(true);

    }

    /**
     * Get the StatusId
     *
     * @return int
     */
    public int getStatusId ()
    {
        return statusId;
    }

    /**
     * Set the value of StatusId
     *
     * @param v new value
     */
    public void setStatusId(int v)
    {
  
        this.statusId = v;
        setModified(true);

    }

      
    
                  
    
        private StatusBean aStatusBean;

    /**
     * sets an associated StatusBean object
     *
     * @param v StatusBean
     */
    public void setStatusBean(StatusBean v)
    {
            if (v == null)
        {
                          setStatusId( 0);
              }
        else
        {
            setStatusId(v.getStatusId());
        }
            aStatusBean = v;
    }

                        
    /**
     * Get the associated StatusBean object
     *
     * @return the associated StatusBean object
     */
    public StatusBean getStatusBean()
    {
        return aStatusBean;
    }

  

                                      
                
    /**
     * Collection to store aggregation of collTaskCommentBeans
     */
    protected List<TaskCommentBean> collTaskCommentBeans;

    /**
     * Returns the collection of TaskCommentBeans
     */
    public List<TaskCommentBean> getTaskCommentBeans()
    {
        return collTaskCommentBeans;
    }

    /**
     * Sets the collection of TaskCommentBeans to the specified value
     */
    public void setTaskCommentBeans(List<TaskCommentBean> list)
    {
        if (list == null)
        {
            collTaskCommentBeans = null;
        }
        else
        {
            collTaskCommentBeans = new ArrayList<TaskCommentBean>(list);
        }
    }

                                          
                
    /**
     * Collection to store aggregation of collTaskFileRelationBeans
     */
    protected List<TaskFileRelationBean> collTaskFileRelationBeans;

    /**
     * Returns the collection of TaskFileRelationBeans
     */
    public List<TaskFileRelationBean> getTaskFileRelationBeans()
    {
        return collTaskFileRelationBeans;
    }

    /**
     * Sets the collection of TaskFileRelationBeans to the specified value
     */
    public void setTaskFileRelationBeans(List<TaskFileRelationBean> list)
    {
        if (list == null)
        {
            collTaskFileRelationBeans = null;
        }
        else
        {
            collTaskFileRelationBeans = new ArrayList<TaskFileRelationBean>(list);
        }
    }

                                          
                
    /**
     * Collection to store aggregation of collAttachedFileBeans
     */
    protected List<AttachedFileBean> collAttachedFileBeans;

    /**
     * Returns the collection of AttachedFileBeans
     */
    public List<AttachedFileBean> getAttachedFileBeans()
    {
        return collAttachedFileBeans;
    }

    /**
     * Sets the collection of AttachedFileBeans to the specified value
     */
    public void setAttachedFileBeans(List<AttachedFileBean> list)
    {
        if (list == null)
        {
            collAttachedFileBeans = null;
        }
        else
        {
            collAttachedFileBeans = new ArrayList<AttachedFileBean>(list);
        }
    }

            }
