
/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque.bean;

import java.io.Serializable;


                
/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Jan 07 21:20:48 GMT+09:00 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TagBean
 */
public abstract class BaseTagBean
    implements Serializable
{

    /**
     * whether the bean or its underlying object has changed
     * since last reading from the database
     */
    private boolean modified = true;

    /**
     * false if the underlying object has been read from the database,
     * true otherwise
     */
    private boolean isNew = true;

  
    /** The value for the tagId field */
    private int tagId;
  
    /** The value for the name field */
    private String name;
                          
    /** The value for the active field */
    private int active = 1;
  
    /** The value for the tagTypeId field */
    private int tagTypeId;


    /**
     * sets whether the bean exists in the database
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * returns whether the bean exists in the database
     */
    public boolean isNew()
    {
        return this.isNew;
    }

    /**
     * sets whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public void setModified(boolean isModified)
    {
        this.modified = isModified;
    }

    /**
     * returns whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public boolean isModified()
    {
        return this.modified;
    }


    /**
     * Get the TagId
     *
     * @return int
     */
    public int getTagId ()
    {
        return tagId;
    }

    /**
     * Set the value of TagId
     *
     * @param v new value
     */
    public void setTagId(int v)
    {
  
        this.tagId = v;
        setModified(true);

    }

    /**
     * Get the Name
     *
     * @return String
     */
    public String getName ()
    {
        return name;
    }

    /**
     * Set the value of Name
     *
     * @param v new value
     */
    public void setName(String v)
    {
  
        this.name = v;
        setModified(true);

    }

    /**
     * Get the Active
     *
     * @return int
     */
    public int getActive ()
    {
        return active;
    }

    /**
     * Set the value of Active
     *
     * @param v new value
     */
    public void setActive(int v)
    {
  
        this.active = v;
        setModified(true);

    }

    /**
     * Get the TagTypeId
     *
     * @return int
     */
    public int getTagTypeId ()
    {
        return tagTypeId;
    }

    /**
     * Set the value of TagTypeId
     *
     * @param v new value
     */
    public void setTagTypeId(int v)
    {
  
        this.tagTypeId = v;
        setModified(true);

    }

      
    
                  
    
        private TagTypeBean aTagTypeBean;

    /**
     * sets an associated TagTypeBean object
     *
     * @param v TagTypeBean
     */
    public void setTagTypeBean(TagTypeBean v)
    {
            if (v == null)
        {
                          setTagTypeId( 0);
              }
        else
        {
            setTagTypeId(v.getTagTypeId());
        }
            aTagTypeBean = v;
    }

                        
    /**
     * Get the associated TagTypeBean object
     *
     * @return the associated TagTypeBean object
     */
    public TagTypeBean getTagTypeBean()
    {
        return aTagTypeBean;
    }

  

        }
