
/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


        
/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Jan 07 21:20:48 GMT+09:00 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to StatusBean
 */
public abstract class BaseStatusBean
    implements Serializable
{

    /**
     * whether the bean or its underlying object has changed
     * since last reading from the database
     */
    private boolean modified = true;

    /**
     * false if the underlying object has been read from the database,
     * true otherwise
     */
    private boolean isNew = true;

  
    /** The value for the statusId field */
    private int statusId;
  
    /** The value for the name field */
    private String name;
                          
    /** The value for the sortOrder field */
    private int sortOrder = 0;
  
    /** The value for the image field */
    private String image;


    /**
     * sets whether the bean exists in the database
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * returns whether the bean exists in the database
     */
    public boolean isNew()
    {
        return this.isNew;
    }

    /**
     * sets whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public void setModified(boolean isModified)
    {
        this.modified = isModified;
    }

    /**
     * returns whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public boolean isModified()
    {
        return this.modified;
    }


    /**
     * Get the StatusId
     *
     * @return int
     */
    public int getStatusId ()
    {
        return statusId;
    }

    /**
     * Set the value of StatusId
     *
     * @param v new value
     */
    public void setStatusId(int v)
    {
  
        this.statusId = v;
        setModified(true);

    }

    /**
     * Get the Name
     *
     * @return String
     */
    public String getName ()
    {
        return name;
    }

    /**
     * Set the value of Name
     *
     * @param v new value
     */
    public void setName(String v)
    {
  
        this.name = v;
        setModified(true);

    }

    /**
     * Get the SortOrder
     *
     * @return int
     */
    public int getSortOrder ()
    {
        return sortOrder;
    }

    /**
     * Set the value of SortOrder
     *
     * @param v new value
     */
    public void setSortOrder(int v)
    {
  
        this.sortOrder = v;
        setModified(true);

    }

    /**
     * Get the Image
     *
     * @return String
     */
    public String getImage ()
    {
        return image;
    }

    /**
     * Set the value of Image
     *
     * @param v new value
     */
    public void setImage(String v)
    {
  
        this.image = v;
        setModified(true);

    }

      

                                      
                
    /**
     * Collection to store aggregation of collTaskBeans
     */
    protected List<TaskBean> collTaskBeans;

    /**
     * Returns the collection of TaskBeans
     */
    public List<TaskBean> getTaskBeans()
    {
        return collTaskBeans;
    }

    /**
     * Sets the collection of TaskBeans to the specified value
     */
    public void setTaskBeans(List<TaskBean> list)
    {
        if (list == null)
        {
            collTaskBeans = null;
        }
        else
        {
            collTaskBeans = new ArrayList<TaskBean>(list);
        }
    }

            }
