/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque;


import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.yher2.workstyle.torque.bean.FileBean;
import net.yher2.workstyle.torque.bean.TaskBean;
import net.yher2.workstyle.torque.bean.TaskFileRelationBean;

import org.apache.commons.collections.map.IdentityMap;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
        
        

/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Jan 07 21:20:48 GMT+09:00 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to TaskFileRelation
 */
public abstract class BaseTaskFileRelation extends BaseObject
{
    /** The Peer class */
    private static final TaskFileRelationPeer peer =
        new TaskFileRelationPeer();

        
    /** The value for the relationId field */
    private int relationId;
      
    /** The value for the taskId field */
    private int taskId;
      
    /** The value for the fileId field */
    private int fileId;
  
            
    /**
     * Get the RelationId
     *
     * @return int
     */
    public int getRelationId()
    {
        return relationId;
    }

                        
    /**
     * Set the value of RelationId
     *
     * @param v new value
     */
    public void setRelationId(int v) 
    {
    
                  if (this.relationId != v)
              {
            this.relationId = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the TaskId
     *
     * @return int
     */
    public int getTaskId()
    {
        return taskId;
    }

                              
    /**
     * Set the value of TaskId
     *
     * @param v new value
     */
    public void setTaskId(int v) throws TorqueException
    {
    
                  if (this.taskId != v)
              {
            this.taskId = v;
            setModified(true);
        }
    
                                  
                if (aTask != null && !(aTask.getTaskId() == v))
                {
            aTask = null;
        }
      
              }
          
    /**
     * Get the FileId
     *
     * @return int
     */
    public int getFileId()
    {
        return fileId;
    }

                              
    /**
     * Set the value of FileId
     *
     * @param v new value
     */
    public void setFileId(int v) throws TorqueException
    {
    
                  if (this.fileId != v)
              {
            this.fileId = v;
            setModified(true);
        }
    
                                  
                if (aFile != null && !(aFile.getFileId() == v))
                {
            aFile = null;
        }
      
              }
  
      
        
                  
    
        private Task aTask;

    /**
     * Declares an association between this object and a Task object
     *
     * @param v Task
     * @throws TorqueException
     */
    public void setTask(Task v) throws TorqueException
    {
            if (v == null)
        {
                          setTaskId( 0);
              }
        else
        {
            setTaskId(v.getTaskId());
        }
            aTask = v;
    }

                        
    /**
     * Returns the associated Task object.
           * If it was not retrieved before, the object is retrieved from
     * the database
           *
     * @return the associated Task object
           * @throws TorqueException
           */
    public Task getTask()
              throws TorqueException
          {
              if (aTask == null && (this.taskId != 0))
        {
                              aTask = TaskPeer.retrieveByPK(SimpleKey.keyFor(this.taskId));
                  
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Task obj = TaskPeer.retrieveByPK(this.taskId);
               obj.add${pCollName}(this);
            */
        }
              return aTask;
    }

    /**
     * Return the associated Task object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated Task object
     * @throws TorqueException
     */
    public Task getTask(Connection connection)
        throws TorqueException
    {
        if (aTask == null && (this.taskId != 0))
        {
                          aTask = TaskPeer.retrieveByPK(SimpleKey.keyFor(this.taskId), connection);
              
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Task obj = TaskPeer.retrieveByPK(this.taskId, connection);
               obj.add${pCollName}(this);
            */
        }
        return aTask;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setTaskKey(ObjectKey key) throws TorqueException
    {
      
                        setTaskId(((NumberKey) key).intValue());
                  }
    
        
                  
    
        private File aFile;

    /**
     * Declares an association between this object and a File object
     *
     * @param v File
     * @throws TorqueException
     */
    public void setFile(File v) throws TorqueException
    {
            if (v == null)
        {
                          setFileId( 0);
              }
        else
        {
            setFileId(v.getFileId());
        }
            aFile = v;
    }

                        
    /**
     * Returns the associated File object.
           * If it was not retrieved before, the object is retrieved from
     * the database
           *
     * @return the associated File object
           * @throws TorqueException
           */
    public File getFile()
              throws TorqueException
          {
              if (aFile == null && (this.fileId != 0))
        {
                              aFile = FilePeer.retrieveByPK(SimpleKey.keyFor(this.fileId));
                  
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               File obj = FilePeer.retrieveByPK(this.fileId);
               obj.add${pCollName}(this);
            */
        }
              return aFile;
    }

    /**
     * Return the associated File object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated File object
     * @throws TorqueException
     */
    public File getFile(Connection connection)
        throws TorqueException
    {
        if (aFile == null && (this.fileId != 0))
        {
                          aFile = FilePeer.retrieveByPK(SimpleKey.keyFor(this.fileId), connection);
              
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               File obj = FilePeer.retrieveByPK(this.fileId, connection);
               obj.add${pCollName}(this);
            */
        }
        return aFile;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setFileKey(ObjectKey key) throws TorqueException
    {
      
                        setFileId(((NumberKey) key).intValue());
                  }
       
                
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
              fieldNames.add("RelationId");
              fieldNames.add("TaskId");
              fieldNames.add("FileId");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
          if (name.equals("RelationId"))
        {
                return new Integer(getRelationId());
            }
          if (name.equals("TaskId"))
        {
                return new Integer(getTaskId());
            }
          if (name.equals("FileId"))
        {
                return new Integer(getFileId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(TaskFileRelationPeer.RELATION_ID))
        {
                return new Integer(getRelationId());
            }
          if (name.equals(TaskFileRelationPeer.TASK_ID))
        {
                return new Integer(getTaskId());
            }
          if (name.equals(TaskFileRelationPeer.FILE_ID))
        {
                return new Integer(getFileId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
        {
                return new Integer(getRelationId());
            }
              if (pos == 1)
        {
                return new Integer(getTaskId());
            }
              if (pos == 2)
        {
                return new Integer(getFileId());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
          save(TaskFileRelationPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TaskFileRelationPeer.doInsert((TaskFileRelation) this, con);
                    setNew(false);
                }
                else
                {
                    TaskFileRelationPeer.doUpdate((TaskFileRelation) this, con);
                }
                }

                      alreadyInSave = false;
        }
      }

                  
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key relationId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
            setRelationId(((NumberKey) key).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
            setRelationId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getRelationId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections and sets the
     * related objects to isNew=true.
       */
      public TaskFileRelation copy() throws TorqueException
    {
        return copyInto(new TaskFileRelation());
    }
  
    protected TaskFileRelation copyInto(TaskFileRelation copyObj) throws TorqueException
    {
          copyObj.setRelationId(relationId);
          copyObj.setTaskId(taskId);
          copyObj.setFileId(fileId);
  
                            copyObj.setRelationId( 0);
                        
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public TaskFileRelationPeer getPeer()
    {
        return peer;
    }

  
    /**
     * Creates a TaskFileRelationBean with the contents of this object
       * This also creates beans for cached related objects, if they exist
       * @return a TaskFileRelationBean with the contents of this object
     */
    public TaskFileRelationBean getBean()
    {
        return getBean(new IdentityMap());
    }

    /**
     * Creates a TaskFileRelationBean with the contents of this object
     * intended for internal use only
     * @param createdBeans a IdentityMap which maps objects
     *        to already created beans
     * @return a TaskFileRelationBean with the contents of this object
     */
    public TaskFileRelationBean getBean(IdentityMap createdBeans)
    {
        TaskFileRelationBean result = (TaskFileRelationBean) createdBeans.get(this);
        if (result != null ) {
            // we have already created a bean for this object, return it
            return result;
        }
        // no bean exists for this object; create a new one
        result = new TaskFileRelationBean();
        createdBeans.put(this, result);

          result.setRelationId(getRelationId());
          result.setTaskId(getTaskId());
          result.setFileId(getFileId());
  
                    
        
      
                                
              if (aTask != null)
        {
            TaskBean relatedBean = aTask.getBean(createdBeans);
            result.setTaskBean(relatedBean);
        }
    
      
                                
              if (aFile != null)
        {
            FileBean relatedBean = aFile.getBean(createdBeans);
            result.setFileBean(relatedBean);
        }
              result.setModified(isModified());
        result.setNew(isNew());
        return result;
    }

    /**
     * Creates an instance of TaskFileRelation with the contents
     * of a TaskFileRelationBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed
     * @param bean the TaskFileRelationBean which contents are used to create
     *        the resulting class
     * @return an instance of TaskFileRelation with the contents of bean
     */
    public static TaskFileRelation createTaskFileRelation(TaskFileRelationBean bean)
        throws TorqueException
    {
        return createTaskFileRelation(bean, new IdentityMap());
    }

    /**
     * Creates an instance of TaskFileRelation with the contents
     * of a TaskFileRelationBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed.
     *
     * This method is intended for internal use only.
     * @param bean the TaskFileRelationBean which contents are used to create
     *        the resulting class
     * @param createdObjects a IdentityMap which maps beans
     *        to already created objects
     * @return an instance of TaskFileRelation with the contents of bean
     */

    public static TaskFileRelation createTaskFileRelation(TaskFileRelationBean bean, IdentityMap createdObjects)
        throws TorqueException
    {
        TaskFileRelation result = (TaskFileRelation) createdObjects.get(bean);
        if (result != null)
        {
            // we already have an object for the bean, return it
            return result;
        }
        result = new TaskFileRelation();
        createdObjects.put(bean, result);

          result.setRelationId(bean.getRelationId());
          result.setTaskId(bean.getTaskId());
          result.setFileId(bean.getFileId());
  
                    
        
      
                                
              {
            TaskBean relatedBean = bean.getTaskBean();
            if (relatedBean != null)
            {
                Task relatedObject = Task.createTask(relatedBean, createdObjects);
                result.setTask(relatedObject);
            }
        }
    
      
                                
              {
            FileBean relatedBean = bean.getFileBean();
            if (relatedBean != null)
            {
                File relatedObject = File.createFile(relatedBean, createdObjects);
                result.setFile(relatedObject);
            }
        }
          result.setModified(bean.isModified());
    result.setNew(bean.isNew());
  	return result;
    }

                      

    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TaskFileRelation:\n");
        str.append("RelationId = ")
               .append(getRelationId())
             .append("\n");
        str.append("TaskId = ")
               .append(getTaskId())
             .append("\n");
        str.append("FileId = ")
               .append(getFileId())
             .append("\n");
        return(str.toString());
    }
}
