/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque;


import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import net.yher2.workstyle.torque.bean.AttachedFileBean;
import net.yher2.workstyle.torque.bean.StatusBean;
import net.yher2.workstyle.torque.bean.TaskBean;
import net.yher2.workstyle.torque.bean.TaskCommentBean;
import net.yher2.workstyle.torque.bean.TaskFileRelationBean;

import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;
            

/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Jan 07 21:20:48 GMT+09:00 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Task
 */
public abstract class BaseTask extends BaseObject
{
    /** The Peer class */
    private static final TaskPeer peer =
        new TaskPeer();

        
    /** The value for the taskId field */
    private int taskId;
      
    /** The value for the contents field */
    private String contents;
                                          
    /** The value for the estimatedManHour field */
    private double estimatedManHour = 0;
      
    /** The value for the tagList field */
    private String tagList;
      
    /** The value for the updateDate field */
    private Date updateDate;
      
    /** The value for the statusId field */
    private int statusId;
  
            
    /**
     * Get the TaskId
     *
     * @return int
     */
    public int getTaskId()
    {
        return taskId;
    }

                                              
    /**
     * Set the value of TaskId
     *
     * @param v new value
     */
    public void setTaskId(int v) throws TorqueException
    {
    
                  if (this.taskId != v)
              {
            this.taskId = v;
            setModified(true);
        }
    
          
                                  
                  // update associated TaskComment
        if (collTaskComments != null)
        {
            for (int i = 0; i < collTaskComments.size(); i++)
            {
                ((TaskComment) collTaskComments.get(i))
                    .setTaskId(v);
            }
        }
                                                    
                  // update associated TaskFileRelation
        if (collTaskFileRelations != null)
        {
            for (int i = 0; i < collTaskFileRelations.size(); i++)
            {
                ((TaskFileRelation) collTaskFileRelations.get(i))
                    .setTaskId(v);
            }
        }
                                                    
                  // update associated AttachedFile
        if (collAttachedFiles != null)
        {
            for (int i = 0; i < collAttachedFiles.size(); i++)
            {
                ((AttachedFile) collAttachedFiles.get(i))
                    .setTaskId(v);
            }
        }
                                }
          
    /**
     * Get the Contents
     *
     * @return String
     */
    public String getContents()
    {
        return contents;
    }

                        
    /**
     * Set the value of Contents
     *
     * @param v new value
     */
    public void setContents(String v) 
    {
    
                  if (!ObjectUtils.equals(this.contents, v))
              {
            this.contents = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the EstimatedManHour
     *
     * @return double
     */
    public double getEstimatedManHour()
    {
        return estimatedManHour;
    }

                        
    /**
     * Set the value of EstimatedManHour
     *
     * @param v new value
     */
    public void setEstimatedManHour(double v) 
    {
    
                  if (this.estimatedManHour != v)
              {
            this.estimatedManHour = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the TagList
     *
     * @return String
     */
    public String getTagList()
    {
        return tagList;
    }

                        
    /**
     * Set the value of TagList
     *
     * @param v new value
     */
    public void setTagList(String v) 
    {
    
                  if (!ObjectUtils.equals(this.tagList, v))
              {
            this.tagList = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the UpdateDate
     *
     * @return Date
     */
    public Date getUpdateDate()
    {
        return updateDate;
    }

                        
    /**
     * Set the value of UpdateDate
     *
     * @param v new value
     */
    public void setUpdateDate(Date v) 
    {
    
                  if (!ObjectUtils.equals(this.updateDate, v))
              {
            this.updateDate = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the StatusId
     *
     * @return int
     */
    public int getStatusId()
    {
        return statusId;
    }

                              
    /**
     * Set the value of StatusId
     *
     * @param v new value
     */
    public void setStatusId(int v) throws TorqueException
    {
    
                  if (this.statusId != v)
              {
            this.statusId = v;
            setModified(true);
        }
    
                                  
                if (aStatus != null && !(aStatus.getStatusId() == v))
                {
            aStatus = null;
        }
      
              }
  
      
        
                  
    
        private Status aStatus;

    /**
     * Declares an association between this object and a Status object
     *
     * @param v Status
     * @throws TorqueException
     */
    public void setStatus(Status v) throws TorqueException
    {
            if (v == null)
        {
                          setStatusId( 0);
              }
        else
        {
            setStatusId(v.getStatusId());
        }
            aStatus = v;
    }

                        
    /**
     * Returns the associated Status object.
           * If it was not retrieved before, the object is retrieved from
     * the database
           *
     * @return the associated Status object
           * @throws TorqueException
           */
    public Status getStatus()
              throws TorqueException
          {
              if (aStatus == null && (this.statusId != 0))
        {
                              aStatus = StatusPeer.retrieveByPK(SimpleKey.keyFor(this.statusId));
                  
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Status obj = StatusPeer.retrieveByPK(this.statusId);
               obj.add${pCollName}(this);
            */
        }
              return aStatus;
    }

    /**
     * Return the associated Status object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated Status object
     * @throws TorqueException
     */
    public Status getStatus(Connection connection)
        throws TorqueException
    {
        if (aStatus == null && (this.statusId != 0))
        {
                          aStatus = StatusPeer.retrieveByPK(SimpleKey.keyFor(this.statusId), connection);
              
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Status obj = StatusPeer.retrieveByPK(this.statusId, connection);
               obj.add${pCollName}(this);
            */
        }
        return aStatus;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setStatusKey(ObjectKey key) throws TorqueException
    {
      
                        setStatusId(((NumberKey) key).intValue());
                  }
       
                                
            
          /**
     * Collection to store aggregation of collTaskComments
     */
    protected List<TaskComment> collTaskComments;

    /**
     * Temporary storage of collTaskComments to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initTaskComments()
    {
        if (collTaskComments == null)
        {
            collTaskComments = new ArrayList<TaskComment>();
        }
    }

        
    /**
     * Method called to associate a TaskComment object to this object
     * through the TaskComment foreign key attribute
     *
     * @param l TaskComment
     * @throws TorqueException
     */
    public void addTaskComment(TaskComment l) throws TorqueException
    {
        getTaskComments().add(l);
        l.setTask((Task) this);
    }

    /**
     * The criteria used to select the current contents of collTaskComments
     */
    private Criteria lastTaskCommentsCriteria = null;
      
    /**
                   * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTaskComments(new Criteria())
                   *
     * @return the collection of associated objects
           * @throws TorqueException
           */
    public List<TaskComment> getTaskComments()
              throws TorqueException
          {
                      if (collTaskComments == null)
        {
            collTaskComments = getTaskComments(new Criteria(10));
        }
                return collTaskComments;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task has previously
           * been saved, it will retrieve related TaskComments from storage.
     * If this Task is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List<TaskComment> getTaskComments(Criteria criteria) throws TorqueException
    {
              if (collTaskComments == null)
        {
            if (isNew())
            {
               collTaskComments = new ArrayList<TaskComment>();
            }
            else
            {
                        criteria.add(TaskCommentPeer.TASK_ID, getTaskId() );
                        collTaskComments = TaskCommentPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                            criteria.add(TaskCommentPeer.TASK_ID, getTaskId());
                            if (!lastTaskCommentsCriteria.equals(criteria))
                {
                    collTaskComments = TaskCommentPeer.doSelect(criteria);
                }
            }
        }
        lastTaskCommentsCriteria = criteria;

        return collTaskComments;
          }

    /**
           * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTaskComments(new Criteria(),Connection)
           * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<TaskComment> getTaskComments(Connection con) throws TorqueException
    {
              if (collTaskComments == null)
        {
            collTaskComments = getTaskComments(new Criteria(10), con);
        }
        return collTaskComments;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task has previously
           * been saved, it will retrieve related TaskComments from storage.
     * If this Task is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<TaskComment> getTaskComments(Criteria criteria, Connection con)
            throws TorqueException
    {
              if (collTaskComments == null)
        {
            if (isNew())
            {
               collTaskComments = new ArrayList<TaskComment>();
            }
            else
            {
                         criteria.add(TaskCommentPeer.TASK_ID, getTaskId());
                         collTaskComments = TaskCommentPeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                             criteria.add(TaskCommentPeer.TASK_ID, getTaskId());
                             if (!lastTaskCommentsCriteria.equals(criteria))
                 {
                     collTaskComments = TaskCommentPeer.doSelect(criteria, con);
                 }
             }
         }
         lastTaskCommentsCriteria = criteria;

         return collTaskComments;
           }

                  
              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task is new, it will return
                 * an empty collection; or if this Task has previously
     * been saved, it will retrieve related TaskComments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Task.
     */
    protected List getTaskCommentsJoinTask(Criteria criteria)
        throws TorqueException
    {
                    if (collTaskComments == null)
        {
            if (isNew())
            {
               collTaskComments = new ArrayList<TaskComment>();
            }
            else
            {
                              criteria.add(TaskCommentPeer.TASK_ID, getTaskId());
                              collTaskComments = TaskCommentPeer.doSelectJoinTask(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(TaskCommentPeer.TASK_ID, getTaskId());
                                    if (!lastTaskCommentsCriteria.equals(criteria))
            {
                collTaskComments = TaskCommentPeer.doSelectJoinTask(criteria);
            }
        }
        lastTaskCommentsCriteria = criteria;

        return collTaskComments;
                }
                            


                          
            
          /**
     * Collection to store aggregation of collTaskFileRelations
     */
    protected List<TaskFileRelation> collTaskFileRelations;

    /**
     * Temporary storage of collTaskFileRelations to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initTaskFileRelations()
    {
        if (collTaskFileRelations == null)
        {
            collTaskFileRelations = new ArrayList<TaskFileRelation>();
        }
    }

        
    /**
     * Method called to associate a TaskFileRelation object to this object
     * through the TaskFileRelation foreign key attribute
     *
     * @param l TaskFileRelation
     * @throws TorqueException
     */
    public void addTaskFileRelation(TaskFileRelation l) throws TorqueException
    {
        getTaskFileRelations().add(l);
        l.setTask((Task) this);
    }

    /**
     * The criteria used to select the current contents of collTaskFileRelations
     */
    private Criteria lastTaskFileRelationsCriteria = null;
      
    /**
                   * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTaskFileRelations(new Criteria())
                   *
     * @return the collection of associated objects
           * @throws TorqueException
           */
    public List<TaskFileRelation> getTaskFileRelations()
              throws TorqueException
          {
                      if (collTaskFileRelations == null)
        {
            collTaskFileRelations = getTaskFileRelations(new Criteria(10));
        }
                return collTaskFileRelations;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task has previously
           * been saved, it will retrieve related TaskFileRelations from storage.
     * If this Task is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List<TaskFileRelation> getTaskFileRelations(Criteria criteria) throws TorqueException
    {
              if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                        criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId() );
                        collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                            criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                            if (!lastTaskFileRelationsCriteria.equals(criteria))
                {
                    collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria);
                }
            }
        }
        lastTaskFileRelationsCriteria = criteria;

        return collTaskFileRelations;
          }

    /**
           * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTaskFileRelations(new Criteria(),Connection)
           * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<TaskFileRelation> getTaskFileRelations(Connection con) throws TorqueException
    {
              if (collTaskFileRelations == null)
        {
            collTaskFileRelations = getTaskFileRelations(new Criteria(10), con);
        }
        return collTaskFileRelations;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task has previously
           * been saved, it will retrieve related TaskFileRelations from storage.
     * If this Task is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<TaskFileRelation> getTaskFileRelations(Criteria criteria, Connection con)
            throws TorqueException
    {
              if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                         criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                         collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                             criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                             if (!lastTaskFileRelationsCriteria.equals(criteria))
                 {
                     collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria, con);
                 }
             }
         }
         lastTaskFileRelationsCriteria = criteria;

         return collTaskFileRelations;
           }

                        
              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task is new, it will return
                 * an empty collection; or if this Task has previously
     * been saved, it will retrieve related TaskFileRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Task.
     */
    protected List getTaskFileRelationsJoinTask(Criteria criteria)
        throws TorqueException
    {
                    if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                              criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                              collTaskFileRelations = TaskFileRelationPeer.doSelectJoinTask(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                                    if (!lastTaskFileRelationsCriteria.equals(criteria))
            {
                collTaskFileRelations = TaskFileRelationPeer.doSelectJoinTask(criteria);
            }
        }
        lastTaskFileRelationsCriteria = criteria;

        return collTaskFileRelations;
                }
                  
                    
                    
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task is new, it will return
                 * an empty collection; or if this Task has previously
     * been saved, it will retrieve related TaskFileRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Task.
     */
    protected List getTaskFileRelationsJoinFile(Criteria criteria)
        throws TorqueException
    {
                    if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                              criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                              collTaskFileRelations = TaskFileRelationPeer.doSelectJoinFile(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(TaskFileRelationPeer.TASK_ID, getTaskId());
                                    if (!lastTaskFileRelationsCriteria.equals(criteria))
            {
                collTaskFileRelations = TaskFileRelationPeer.doSelectJoinFile(criteria);
            }
        }
        lastTaskFileRelationsCriteria = criteria;

        return collTaskFileRelations;
                }
                            


                          
            
          /**
     * Collection to store aggregation of collAttachedFiles
     */
    protected List<AttachedFile> collAttachedFiles;

    /**
     * Temporary storage of collAttachedFiles to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initAttachedFiles()
    {
        if (collAttachedFiles == null)
        {
            collAttachedFiles = new ArrayList<AttachedFile>();
        }
    }

        
    /**
     * Method called to associate a AttachedFile object to this object
     * through the AttachedFile foreign key attribute
     *
     * @param l AttachedFile
     * @throws TorqueException
     */
    public void addAttachedFile(AttachedFile l) throws TorqueException
    {
        getAttachedFiles().add(l);
        l.setTask((Task) this);
    }

    /**
     * The criteria used to select the current contents of collAttachedFiles
     */
    private Criteria lastAttachedFilesCriteria = null;
      
    /**
                   * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getAttachedFiles(new Criteria())
                   *
     * @return the collection of associated objects
           * @throws TorqueException
           */
    public List<AttachedFile> getAttachedFiles()
              throws TorqueException
          {
                      if (collAttachedFiles == null)
        {
            collAttachedFiles = getAttachedFiles(new Criteria(10));
        }
                return collAttachedFiles;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task has previously
           * been saved, it will retrieve related AttachedFiles from storage.
     * If this Task is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List<AttachedFile> getAttachedFiles(Criteria criteria) throws TorqueException
    {
              if (collAttachedFiles == null)
        {
            if (isNew())
            {
               collAttachedFiles = new ArrayList<AttachedFile>();
            }
            else
            {
                        criteria.add(AttachedFilePeer.TASK_ID, getTaskId() );
                        collAttachedFiles = AttachedFilePeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                            criteria.add(AttachedFilePeer.TASK_ID, getTaskId());
                            if (!lastAttachedFilesCriteria.equals(criteria))
                {
                    collAttachedFiles = AttachedFilePeer.doSelect(criteria);
                }
            }
        }
        lastAttachedFilesCriteria = criteria;

        return collAttachedFiles;
          }

    /**
           * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getAttachedFiles(new Criteria(),Connection)
           * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<AttachedFile> getAttachedFiles(Connection con) throws TorqueException
    {
              if (collAttachedFiles == null)
        {
            collAttachedFiles = getAttachedFiles(new Criteria(10), con);
        }
        return collAttachedFiles;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task has previously
           * been saved, it will retrieve related AttachedFiles from storage.
     * If this Task is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<AttachedFile> getAttachedFiles(Criteria criteria, Connection con)
            throws TorqueException
    {
              if (collAttachedFiles == null)
        {
            if (isNew())
            {
               collAttachedFiles = new ArrayList<AttachedFile>();
            }
            else
            {
                         criteria.add(AttachedFilePeer.TASK_ID, getTaskId());
                         collAttachedFiles = AttachedFilePeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                             criteria.add(AttachedFilePeer.TASK_ID, getTaskId());
                             if (!lastAttachedFilesCriteria.equals(criteria))
                 {
                     collAttachedFiles = AttachedFilePeer.doSelect(criteria, con);
                 }
             }
         }
         lastAttachedFilesCriteria = criteria;

         return collAttachedFiles;
           }

                  
              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Task is new, it will return
                 * an empty collection; or if this Task has previously
     * been saved, it will retrieve related AttachedFiles from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Task.
     */
    protected List getAttachedFilesJoinTask(Criteria criteria)
        throws TorqueException
    {
                    if (collAttachedFiles == null)
        {
            if (isNew())
            {
               collAttachedFiles = new ArrayList<AttachedFile>();
            }
            else
            {
                              criteria.add(AttachedFilePeer.TASK_ID, getTaskId());
                              collAttachedFiles = AttachedFilePeer.doSelectJoinTask(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(AttachedFilePeer.TASK_ID, getTaskId());
                                    if (!lastAttachedFilesCriteria.equals(criteria))
            {
                collAttachedFiles = AttachedFilePeer.doSelectJoinTask(criteria);
            }
        }
        lastAttachedFilesCriteria = criteria;

        return collAttachedFiles;
                }
                            


          
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
              fieldNames.add("TaskId");
              fieldNames.add("Contents");
              fieldNames.add("EstimatedManHour");
              fieldNames.add("TagList");
              fieldNames.add("UpdateDate");
              fieldNames.add("StatusId");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
          if (name.equals("TaskId"))
        {
                return new Integer(getTaskId());
            }
          if (name.equals("Contents"))
        {
                return getContents();
            }
          if (name.equals("EstimatedManHour"))
        {
                return new Double(getEstimatedManHour());
            }
          if (name.equals("TagList"))
        {
                return getTagList();
            }
          if (name.equals("UpdateDate"))
        {
                return getUpdateDate();
            }
          if (name.equals("StatusId"))
        {
                return new Integer(getStatusId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(TaskPeer.TASK_ID))
        {
                return new Integer(getTaskId());
            }
          if (name.equals(TaskPeer.CONTENTS))
        {
                return getContents();
            }
          if (name.equals(TaskPeer.ESTIMATED_MAN_HOUR))
        {
                return new Double(getEstimatedManHour());
            }
          if (name.equals(TaskPeer.TAG_LIST))
        {
                return getTagList();
            }
          if (name.equals(TaskPeer.UPDATE_DATE))
        {
                return getUpdateDate();
            }
          if (name.equals(TaskPeer.STATUS_ID))
        {
                return new Integer(getStatusId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
        {
                return new Integer(getTaskId());
            }
              if (pos == 1)
        {
                return getContents();
            }
              if (pos == 2)
        {
                return new Double(getEstimatedManHour());
            }
              if (pos == 3)
        {
                return getTagList();
            }
              if (pos == 4)
        {
                return getUpdateDate();
            }
              if (pos == 5)
        {
                return new Integer(getStatusId());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
          save(TaskPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TaskPeer.doInsert((Task) this, con);
                    setNew(false);
                }
                else
                {
                    TaskPeer.doUpdate((Task) this, con);
                }
                }

                                      
                                    if (collTaskComments != null)
            {
                for (int i = 0; i < collTaskComments.size(); i++)
                {
                    ((TaskComment) collTaskComments.get(i)).save(con);
                }
            }
                                                  
                                    if (collTaskFileRelations != null)
            {
                for (int i = 0; i < collTaskFileRelations.size(); i++)
                {
                    ((TaskFileRelation) collTaskFileRelations.get(i)).save(con);
                }
            }
                                                  
                                    if (collAttachedFiles != null)
            {
                for (int i = 0; i < collAttachedFiles.size(); i++)
                {
                    ((AttachedFile) collAttachedFiles.get(i)).save(con);
                }
            }
                                  alreadyInSave = false;
        }
      }

                        
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key taskId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        throws TorqueException
    {
            setTaskId(((NumberKey) key).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
            setTaskId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getTaskId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections and sets the
     * related objects to isNew=true.
       */
      public Task copy() throws TorqueException
    {
        return copyInto(new Task());
    }
  
    protected Task copyInto(Task copyObj) throws TorqueException
    {
          copyObj.setTaskId(taskId);
          copyObj.setContents(contents);
          copyObj.setEstimatedManHour(estimatedManHour);
          copyObj.setTagList(tagList);
          copyObj.setUpdateDate(updateDate);
          copyObj.setStatusId(statusId);
  
                            copyObj.setTaskId( 0);
                                          
                                      
                            
        List v = getTaskComments();
                            if (v != null)
        {
            for (int i = 0; i < v.size(); i++)
            {
                TaskComment obj = (TaskComment) v.get(i);
                copyObj.addTaskComment(obj.copy());
            }
        }
        else
        {
            copyObj.collTaskComments = null;
        }
                                                  
                            
        v = getTaskFileRelations();
                            if (v != null)
        {
            for (int i = 0; i < v.size(); i++)
            {
                TaskFileRelation obj = (TaskFileRelation) v.get(i);
                copyObj.addTaskFileRelation(obj.copy());
            }
        }
        else
        {
            copyObj.collTaskFileRelations = null;
        }
                                                  
                            
        v = getAttachedFiles();
                            if (v != null)
        {
            for (int i = 0; i < v.size(); i++)
            {
                AttachedFile obj = (AttachedFile) v.get(i);
                copyObj.addAttachedFile(obj.copy());
            }
        }
        else
        {
            copyObj.collAttachedFiles = null;
        }
                            return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public TaskPeer getPeer()
    {
        return peer;
    }

  
    /**
     * Creates a TaskBean with the contents of this object
       * This also creates beans for cached related objects, if they exist
       * @return a TaskBean with the contents of this object
     */
    public TaskBean getBean()
    {
        return getBean(new IdentityMap());
    }

    /**
     * Creates a TaskBean with the contents of this object
     * intended for internal use only
     * @param createdBeans a IdentityMap which maps objects
     *        to already created beans
     * @return a TaskBean with the contents of this object
     */
    public TaskBean getBean(IdentityMap createdBeans)
    {
        TaskBean result = (TaskBean) createdBeans.get(this);
        if (result != null ) {
            // we have already created a bean for this object, return it
            return result;
        }
        // no bean exists for this object; create a new one
        result = new TaskBean();
        createdBeans.put(this, result);

          result.setTaskId(getTaskId());
          result.setContents(getContents());
          result.setEstimatedManHour(getEstimatedManHour());
          result.setTagList(getTagList());
          result.setUpdateDate(getUpdateDate());
          result.setStatusId(getStatusId());
  
                                                        
                    
                  if (collTaskComments != null)
        {
            List<TaskCommentBean> relatedBeans = new ArrayList<TaskCommentBean>(collTaskComments.size());
            for (Iterator collTaskCommentsIt = collTaskComments.iterator(); collTaskCommentsIt.hasNext(); )
            {
                TaskComment related = (TaskComment) collTaskCommentsIt.next();
                TaskCommentBean relatedBean = related.getBean(createdBeans);
                relatedBeans.add(relatedBean);
            }
            result.setTaskCommentBeans(relatedBeans);
        }
                                                      
                    
                  if (collTaskFileRelations != null)
        {
            List<TaskFileRelationBean> relatedBeans = new ArrayList<TaskFileRelationBean>(collTaskFileRelations.size());
            for (Iterator collTaskFileRelationsIt = collTaskFileRelations.iterator(); collTaskFileRelationsIt.hasNext(); )
            {
                TaskFileRelation related = (TaskFileRelation) collTaskFileRelationsIt.next();
                TaskFileRelationBean relatedBean = related.getBean(createdBeans);
                relatedBeans.add(relatedBean);
            }
            result.setTaskFileRelationBeans(relatedBeans);
        }
                                                      
                    
                  if (collAttachedFiles != null)
        {
            List<AttachedFileBean> relatedBeans = new ArrayList<AttachedFileBean>(collAttachedFiles.size());
            for (Iterator collAttachedFilesIt = collAttachedFiles.iterator(); collAttachedFilesIt.hasNext(); )
            {
                AttachedFile related = (AttachedFile) collAttachedFilesIt.next();
                AttachedFileBean relatedBean = related.getBean(createdBeans);
                relatedBeans.add(relatedBean);
            }
            result.setAttachedFileBeans(relatedBeans);
        }
                  
        
      
                                
              if (aStatus != null)
        {
            StatusBean relatedBean = aStatus.getBean(createdBeans);
            result.setStatusBean(relatedBean);
        }
              result.setModified(isModified());
        result.setNew(isNew());
        return result;
    }

    /**
     * Creates an instance of Task with the contents
     * of a TaskBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed
     * @param bean the TaskBean which contents are used to create
     *        the resulting class
     * @return an instance of Task with the contents of bean
     */
    public static Task createTask(TaskBean bean)
        throws TorqueException
    {
        return createTask(bean, new IdentityMap());
    }

    /**
     * Creates an instance of Task with the contents
     * of a TaskBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed.
     *
     * This method is intended for internal use only.
     * @param bean the TaskBean which contents are used to create
     *        the resulting class
     * @param createdObjects a IdentityMap which maps beans
     *        to already created objects
     * @return an instance of Task with the contents of bean
     */

    public static Task createTask(TaskBean bean, IdentityMap createdObjects)
        throws TorqueException
    {
        Task result = (Task) createdObjects.get(bean);
        if (result != null)
        {
            // we already have an object for the bean, return it
            return result;
        }
        result = new Task();
        createdObjects.put(bean, result);

          result.setTaskId(bean.getTaskId());
          result.setContents(bean.getContents());
          result.setEstimatedManHour(bean.getEstimatedManHour());
          result.setTagList(bean.getTagList());
          result.setUpdateDate(bean.getUpdateDate());
          result.setStatusId(bean.getStatusId());
  
                                                        
                    
        {
            List relatedBeans = bean.getTaskCommentBeans();
            if (relatedBeans != null)
            {
                for (Iterator relatedBeansIt = relatedBeans.iterator(); relatedBeansIt.hasNext(); )
                {
                    TaskCommentBean relatedBean = (TaskCommentBean) relatedBeansIt.next();
                    TaskComment related = TaskComment.createTaskComment(relatedBean, createdObjects);
                    result.addTaskCommentFromBean(related);
                }
            }
        }
                                                      
                    
        {
            List relatedBeans = bean.getTaskFileRelationBeans();
            if (relatedBeans != null)
            {
                for (Iterator relatedBeansIt = relatedBeans.iterator(); relatedBeansIt.hasNext(); )
                {
                    TaskFileRelationBean relatedBean = (TaskFileRelationBean) relatedBeansIt.next();
                    TaskFileRelation related = TaskFileRelation.createTaskFileRelation(relatedBean, createdObjects);
                    result.addTaskFileRelationFromBean(related);
                }
            }
        }
                                                      
                    
        {
            List relatedBeans = bean.getAttachedFileBeans();
            if (relatedBeans != null)
            {
                for (Iterator relatedBeansIt = relatedBeans.iterator(); relatedBeansIt.hasNext(); )
                {
                    AttachedFileBean relatedBean = (AttachedFileBean) relatedBeansIt.next();
                    AttachedFile related = AttachedFile.createAttachedFile(relatedBean, createdObjects);
                    result.addAttachedFileFromBean(related);
                }
            }
        }
                  
        
      
                                
              {
            StatusBean relatedBean = bean.getStatusBean();
            if (relatedBean != null)
            {
                Status relatedObject = Status.createStatus(relatedBean, createdObjects);
                result.setStatus(relatedObject);
            }
        }
          result.setModified(bean.isModified());
    result.setNew(bean.isNew());
  	return result;
    }

                                                        
                    
    /**
     * Method called to associate a TaskComment object to this object.
     * through the TaskComment foreign key attribute
     *
     * @param toAdd TaskComment
     */
    protected void addTaskCommentFromBean(TaskComment toAdd)
    {
        initTaskComments();
        collTaskComments.add(toAdd);
    }
                                                      
                    
    /**
     * Method called to associate a TaskFileRelation object to this object.
     * through the TaskFileRelation foreign key attribute
     *
     * @param toAdd TaskFileRelation
     */
    protected void addTaskFileRelationFromBean(TaskFileRelation toAdd)
    {
        initTaskFileRelations();
        collTaskFileRelations.add(toAdd);
    }
                                                      
                    
    /**
     * Method called to associate a AttachedFile object to this object.
     * through the AttachedFile foreign key attribute
     *
     * @param toAdd AttachedFile
     */
    protected void addAttachedFileFromBean(AttachedFile toAdd)
    {
        initAttachedFiles();
        collAttachedFiles.add(toAdd);
    }
                    

    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("Task:\n");
        str.append("TaskId = ")
               .append(getTaskId())
             .append("\n");
        str.append("Contents = ")
               .append(getContents())
             .append("\n");
        str.append("EstimatedManHour = ")
               .append(getEstimatedManHour())
             .append("\n");
        str.append("TagList = ")
               .append(getTagList())
             .append("\n");
        str.append("UpdateDate = ")
               .append(getUpdateDate())
             .append("\n");
        str.append("StatusId = ")
               .append(getStatusId())
             .append("\n");
        return(str.toString());
    }
}
