/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque;


import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.yher2.workstyle.torque.bean.TagBean;
import net.yher2.workstyle.torque.bean.TagTypeBean;

import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
        
        

/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Jan 07 21:20:48 GMT+09:00 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Tag
 */
public abstract class BaseTag extends BaseObject
{
    /** The Peer class */
    private static final TagPeer peer =
        new TagPeer();

        
    /** The value for the tagId field */
    private int tagId;
      
    /** The value for the name field */
    private String name;
                                          
    /** The value for the active field */
    private int active = 1;
      
    /** The value for the tagTypeId field */
    private int tagTypeId;
  
            
    /**
     * Get the TagId
     *
     * @return int
     */
    public int getTagId()
    {
        return tagId;
    }

                        
    /**
     * Set the value of TagId
     *
     * @param v new value
     */
    public void setTagId(int v) 
    {
    
                  if (this.tagId != v)
              {
            this.tagId = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the Name
     *
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     *
     * @param v new value
     */
    public void setName(String v) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the Active
     *
     * @return int
     */
    public int getActive()
    {
        return active;
    }

                        
    /**
     * Set the value of Active
     *
     * @param v new value
     */
    public void setActive(int v) 
    {
    
                  if (this.active != v)
              {
            this.active = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the TagTypeId
     *
     * @return int
     */
    public int getTagTypeId()
    {
        return tagTypeId;
    }

                              
    /**
     * Set the value of TagTypeId
     *
     * @param v new value
     */
    public void setTagTypeId(int v) throws TorqueException
    {
    
                  if (this.tagTypeId != v)
              {
            this.tagTypeId = v;
            setModified(true);
        }
    
                                  
                if (aTagType != null && !(aTagType.getTagTypeId() == v))
                {
            aTagType = null;
        }
      
              }
  
      
        
                  
    
        private TagType aTagType;

    /**
     * Declares an association between this object and a TagType object
     *
     * @param v TagType
     * @throws TorqueException
     */
    public void setTagType(TagType v) throws TorqueException
    {
            if (v == null)
        {
                          setTagTypeId( 0);
              }
        else
        {
            setTagTypeId(v.getTagTypeId());
        }
            aTagType = v;
    }

                        
    /**
     * Returns the associated TagType object.
           * If it was not retrieved before, the object is retrieved from
     * the database
           *
     * @return the associated TagType object
           * @throws TorqueException
           */
    public TagType getTagType()
              throws TorqueException
          {
              if (aTagType == null && (this.tagTypeId != 0))
        {
                              aTagType = TagTypePeer.retrieveByPK(SimpleKey.keyFor(this.tagTypeId));
                  
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               TagType obj = TagTypePeer.retrieveByPK(this.tagTypeId);
               obj.add${pCollName}(this);
            */
        }
              return aTagType;
    }

    /**
     * Return the associated TagType object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated TagType object
     * @throws TorqueException
     */
    public TagType getTagType(Connection connection)
        throws TorqueException
    {
        if (aTagType == null && (this.tagTypeId != 0))
        {
                          aTagType = TagTypePeer.retrieveByPK(SimpleKey.keyFor(this.tagTypeId), connection);
              
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               TagType obj = TagTypePeer.retrieveByPK(this.tagTypeId, connection);
               obj.add${pCollName}(this);
            */
        }
        return aTagType;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setTagTypeKey(ObjectKey key) throws TorqueException
    {
      
                        setTagTypeId(((NumberKey) key).intValue());
                  }
       
                
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
              fieldNames.add("TagId");
              fieldNames.add("Name");
              fieldNames.add("Active");
              fieldNames.add("TagTypeId");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
          if (name.equals("TagId"))
        {
                return new Integer(getTagId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("Active"))
        {
                return new Integer(getActive());
            }
          if (name.equals("TagTypeId"))
        {
                return new Integer(getTagTypeId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(TagPeer.TAG_ID))
        {
                return new Integer(getTagId());
            }
          if (name.equals(TagPeer.NAME))
        {
                return getName();
            }
          if (name.equals(TagPeer.ACTIVE))
        {
                return new Integer(getActive());
            }
          if (name.equals(TagPeer.TAG_TYPE_ID))
        {
                return new Integer(getTagTypeId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
        {
                return new Integer(getTagId());
            }
              if (pos == 1)
        {
                return getName();
            }
              if (pos == 2)
        {
                return new Integer(getActive());
            }
              if (pos == 3)
        {
                return new Integer(getTagTypeId());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
          save(TagPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TagPeer.doInsert((Tag) this, con);
                    setNew(false);
                }
                else
                {
                    TagPeer.doUpdate((Tag) this, con);
                }
                }

                      alreadyInSave = false;
        }
      }

                  
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key tagId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
            setTagId(((NumberKey) key).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
            setTagId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getTagId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections and sets the
     * related objects to isNew=true.
       */
      public Tag copy() throws TorqueException
    {
        return copyInto(new Tag());
    }
  
    protected Tag copyInto(Tag copyObj) throws TorqueException
    {
          copyObj.setTagId(tagId);
          copyObj.setName(name);
          copyObj.setActive(active);
          copyObj.setTagTypeId(tagTypeId);
  
                            copyObj.setTagId( 0);
                              
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public TagPeer getPeer()
    {
        return peer;
    }

  
    /**
     * Creates a TagBean with the contents of this object
       * This also creates beans for cached related objects, if they exist
       * @return a TagBean with the contents of this object
     */
    public TagBean getBean()
    {
        return getBean(new IdentityMap());
    }

    /**
     * Creates a TagBean with the contents of this object
     * intended for internal use only
     * @param createdBeans a IdentityMap which maps objects
     *        to already created beans
     * @return a TagBean with the contents of this object
     */
    public TagBean getBean(IdentityMap createdBeans)
    {
        TagBean result = (TagBean) createdBeans.get(this);
        if (result != null ) {
            // we have already created a bean for this object, return it
            return result;
        }
        // no bean exists for this object; create a new one
        result = new TagBean();
        createdBeans.put(this, result);

          result.setTagId(getTagId());
          result.setName(getName());
          result.setActive(getActive());
          result.setTagTypeId(getTagTypeId());
  
                    
        
      
                                
              if (aTagType != null)
        {
            TagTypeBean relatedBean = aTagType.getBean(createdBeans);
            result.setTagTypeBean(relatedBean);
        }
              result.setModified(isModified());
        result.setNew(isNew());
        return result;
    }

    /**
     * Creates an instance of Tag with the contents
     * of a TagBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed
     * @param bean the TagBean which contents are used to create
     *        the resulting class
     * @return an instance of Tag with the contents of bean
     */
    public static Tag createTag(TagBean bean)
        throws TorqueException
    {
        return createTag(bean, new IdentityMap());
    }

    /**
     * Creates an instance of Tag with the contents
     * of a TagBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed.
     *
     * This method is intended for internal use only.
     * @param bean the TagBean which contents are used to create
     *        the resulting class
     * @param createdObjects a IdentityMap which maps beans
     *        to already created objects
     * @return an instance of Tag with the contents of bean
     */

    public static Tag createTag(TagBean bean, IdentityMap createdObjects)
        throws TorqueException
    {
        Tag result = (Tag) createdObjects.get(bean);
        if (result != null)
        {
            // we already have an object for the bean, return it
            return result;
        }
        result = new Tag();
        createdObjects.put(bean, result);

          result.setTagId(bean.getTagId());
          result.setName(bean.getName());
          result.setActive(bean.getActive());
          result.setTagTypeId(bean.getTagTypeId());
  
                    
        
      
                                
              {
            TagTypeBean relatedBean = bean.getTagTypeBean();
            if (relatedBean != null)
            {
                TagType relatedObject = TagType.createTagType(relatedBean, createdObjects);
                result.setTagType(relatedObject);
            }
        }
          result.setModified(bean.isModified());
    result.setNew(bean.isNew());
  	return result;
    }

                      

    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("Tag:\n");
        str.append("TagId = ")
               .append(getTagId())
             .append("\n");
        str.append("Name = ")
               .append(getName())
             .append("\n");
        str.append("Active = ")
               .append(getActive())
             .append("\n");
        str.append("TagTypeId = ")
               .append(getTagTypeId())
             .append("\n");
        return(str.toString());
    }
}
