/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.action.task;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import net.yher2.commons.lang.Pager;
import net.yher2.workstyle.TaskQuery;
import net.yher2.workstyle.exception.NotFoundException;
import net.yher2.workstyle.manager.StatusManager;
import net.yher2.workstyle.manager.TagManager;
import net.yher2.workstyle.manager.TaskManager;
import net.yher2.workstyle.torque.bean.TagBean;
import net.yher2.workstyle.torque.bean.TaskBean;

import org.apache.torque.TorqueException;

public class TaskUtils {
	public static final String ATTRIBUTE_TAG_LIST = "tagList";
	public static final String ATTRIBUTE_TAG_MAP = "tagMap";
	public static final String ATTRIBUTE_STATUS_LIST = "statusList";
	public static final String ATTRIBUTE_TASK_LIST = "taskList";
	public static final String ATTRIBUTE_TASK = "task";
	public static final String SESSION_TASK_QUERY = "taskQuery";
	public static final String SESSION_TASK_PAGER = "taskPager";
	
	private Connection con = null;
	private HttpServletRequest request;
	
	public TaskUtils(HttpServletRequest request, Connection con) {
		this.con = con;
		this.request = request;
	}

	public void prepare() throws TorqueException {
		request.setAttribute(ATTRIBUTE_STATUS_LIST, new StatusManager(con).list());
		prepareTag();
	}
	
	public void prepareTag() throws TorqueException {
		List<TagBean> tagList = new TagManager(con).list();
		Map<String, TagBean> tagMap = new HashMap<String, TagBean>();
		for (TagBean tag : tagList) {
			tagMap.put(tag.getName(), tag);
		}
		request.setAttribute(TaskUtils.ATTRIBUTE_TAG_LIST, tagList);
		request.setAttribute(TaskUtils.ATTRIBUTE_TAG_MAP, tagMap);
	}

	public void search() throws TorqueException {
		search(getQuery(), 
				(Pager)request.getSession().getAttribute(SESSION_TASK_PAGER));
	}
	public void search(TaskQuery query, Pager pager) throws TorqueException {
		if (pager == null) pager = new Pager();
		if (query == null) query = new TaskQuery();
		
		prepareSearch(query, pager, new TaskManager(con).search(query, pager));
	}
	public List<TaskBean> searchDetail(TaskQuery query, Pager pager) throws TorqueException {
		if (pager == null) pager = new Pager();
		if (query == null) query = new TaskQuery();
		
		List<TaskBean> taskList = new TaskManager(con).searchDetail(query, pager);
		prepareSearch(query, pager, taskList);
		return taskList;
	}
	
	private void prepareSearch(TaskQuery query, Pager pager, List<TaskBean> taskList) throws TorqueException {
		request.setAttribute(ATTRIBUTE_TASK_LIST, taskList);
		request.getSession().setAttribute(SESSION_TASK_PAGER, pager);
		request.getSession().setAttribute(SESSION_TASK_QUERY, query);
		
		prepare();
	}
	
	public void get(int taskId) throws TorqueException, NotFoundException {
		request.setAttribute(ATTRIBUTE_TASK, new TaskManager(con).get(taskId));
		prepare();
	}
	
	public TaskQuery getQuery() {
		TaskQuery query = (TaskQuery)request.getSession().getAttribute(SESSION_TASK_QUERY);
		if (query == null) query = new TaskQuery();
		request.getSession().setAttribute(SESSION_TASK_QUERY, query);
		return query;
	}
}
