/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.action.task;

import javax.servlet.http.HttpServletRequest;

import net.yher2.commons.struts.Validator;
import net.yher2.workstyle.Properties;
import net.yher2.workstyle.torque.bean.TaskBean;
import net.yher2.workstyle.torque.bean.TaskCommentBean;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

public class EditForm extends AddForm {
	public static final String FORM_NAME = "editTaskForm";
	private int taskId;
	
	public boolean hasTag(String aTag) {
		return TaskBean.hasTag(getTagList(), aTag);
	}

	@Override
	public TaskCommentBean getCommentBean() {
		if (!hasComment()) return null;
		TaskCommentBean bean = super.getCommentBean();
		bean.setTaskId(getTaskId());
		return bean;
	}

	@Override
	protected TaskBean getTaskBean() {
		TaskBean bean = super.getTaskBean();
		bean.setTaskId(getTaskId());
		return bean;
	}

	protected void setTaskBean(TaskBean bean) {
		setTaskId(bean.getTaskId());
		setStatusId(bean.getStatusId());
		setContents(bean.getContents());
		setTagList(bean.getTagList());
		setEstimatedManHour(Double.toString(bean.getEstimatedManHour()));
	}

	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		taskId = 0;
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyId(Properties.TASK_ID, taskId);
		return validator.getErrors();
	}

	public int getTaskId() {
		return taskId;
	}

	public void setTaskId(int taskId) {
		this.taskId = taskId;
	}
	
}
