/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.action.task;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;

import javax.servlet.http.HttpServletRequest;

import net.yher2.commons.lang.NumberUtils;
import net.yher2.commons.lang.Resource;
import net.yher2.commons.struts.Validator;
import net.yher2.commons.torque.Transaction;
import net.yher2.workstyle.FileData;
import net.yher2.workstyle.Properties;
import net.yher2.workstyle.torque.Status;
import net.yher2.workstyle.torque.bean.TaskBean;
import net.yher2.workstyle.torque.bean.TaskCommentBean;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;

public class AddForm extends ActionForm {
	private Log log = LogFactory.getLog(this.getClass());
	
	private int statusId;
	private String contents;
	private String estimatedManHour;
	private String tagList;
	private FormFile attachedFile;
	
	private String comment;
	private String commentator;
	
	private String dirPath;
	
	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		statusId = Status.NORMAL;
		contents = "";
		estimatedManHour = "";
		tagList = "";
		attachedFile = null;
		
		comment = "";
		commentator = "";
		
		dirPath = getServlet().getServletContext().getRealPath(Resource.getString("attachement.dir"));
		
		Connection con = null;
		try {
			con = Transaction.begin(Torque.getDefaultDB());
			new TaskUtils(request, con).prepare();
			Transaction.commit(con);
		} catch (TorqueException e) {
			log.error("初期化エラー", e);
		} finally {
			try {
				Transaction.rollback(con);
			} catch (TorqueException e) {
				log.error("初期化エラー", e);
			}
		}
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyRequired(Properties.STATUS, statusId);
		validator.verifyRequired(Properties.TASK, contents);
		validator.verifyMaxLength(Properties.TASK, contents, 7000);
		validator.verifyMaxLength(Properties.TAG, tagList, 200);
		validator.verifyMaxLength(Properties.COMMENT, comment, 1000);
		validator.verifyMaxLength(Properties.COMMENTATOR, commentator, 50);
		
		if (hasComment()) {
			validator.verifyRequired(Properties.COMMENT, comment);
			validator.verifyRequired(Properties.COMMENTATOR, commentator);
		}
		return validator.getErrors();
	}
	
	protected TaskBean getTaskBean() {
		TaskBean task = new TaskBean();
		task.setStatusId(getStatusId());
		task.setContents(getContents());
		task.setTagList(getTagList());
		task.setEstimatedManHour(NumberUtils.parseDouble(getEstimatedManHour()));
		return task;
	}
	protected TaskCommentBean getCommentBean() {
		if (!hasComment()) return null;
		TaskCommentBean commentBean = new TaskCommentBean();
		commentBean.setContents(getComment());
		commentBean.setCommentator(getCommentator());
		return commentBean;
	}
	
	protected FileData getFileData() throws FileNotFoundException, IOException {
		if (getAttachedFile() == null || getAttachedFile().getFileSize() == 0) return null;
		FileData file = new FileData();
		file.setName(getAttachedFile().getFileName());
		file.setData(getAttachedFile().getFileData());
		file.setDirPath(dirPath);
		return file;
	}
	protected boolean hasComment() {
		return (StringUtils.isNotBlank(comment) || StringUtils.isNotBlank(commentator));
	}
	
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	public String getCommentator() {
		return commentator;
	}
	public void setCommentator(String commentator) {
		this.commentator = commentator;
	}
	public String getContents() {
		return contents;
	}
	public void setContents(String contents) {
		this.contents = contents;
	}
	public String getEstimatedManHour() {
		return estimatedManHour;
	}
	public void setEstimatedManHour(String estimatedManHour) {
		this.estimatedManHour = estimatedManHour;
	}
	public int getStatusId() {
		return statusId;
	}
	public void setStatusId(int status) {
		this.statusId = status;
	}

	public FormFile getAttachedFile() {
		return attachedFile;
	}

	public void setAttachedFile(FormFile attachedFile) {
		this.attachedFile = attachedFile;
	}

	public String getTagList() {
		return tagList;
	}

	public void setTagList(String tagList) {
		this.tagList = TaskBean.normalizeTagList(tagList);
	}
	
	
}
