/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.avalon;

import java.sql.Connection;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueInstance;
import org.apache.torque.adapter.DB;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;

public class TorqueComponent
extends AbstractLogEnabled
implements Component,
Configurable,
Initializable,
Contextualizable,
Startable,
ThreadSafe {
    private Context context = null;
    private TorqueInstance torqueInstance = null;
    private String configFile = null;

    public TorqueComponent() {
        this.torqueInstance = Torque.getInstance();
    }

    protected TorqueComponent(TorqueInstance torqueInstance) {
        this.torqueInstance = torqueInstance;
    }

    private TorqueInstance getTorque() {
        return this.torqueInstance;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.getLogger().debug("configure(" + configuration + ")");
        String configFile = configuration.getChild("configfile").getValue();
        String appRoot = null;
        try {
            appRoot = this.context == null ? null : (String)this.context.get((Object)"componentAppRoot");
        }
        catch (ContextException ce) {
            this.getLogger().error("Could not load Application Root from Context");
        }
        if (StringUtils.isNotEmpty((String)appRoot)) {
            if (appRoot.endsWith("/")) {
                appRoot = appRoot.substring(0, appRoot.length() - 1);
                this.getLogger().debug("Application Root changed to " + appRoot);
            }
            if (configFile.startsWith("/")) {
                configFile = configFile.substring(1);
                this.getLogger().debug("Config File changes to " + configFile);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(appRoot);
            sb.append('/');
            sb.append(configFile);
            configFile = sb.toString();
        }
        this.getLogger().debug("Config File is " + configFile);
        this.configFile = configFile;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void initialize() throws Exception {
        this.getLogger().debug("initialize()");
        this.getTorque().init(this.configFile);
    }

    public void start() {
        this.getLogger().debug("start()");
    }

    public void stop() {
        this.getLogger().debug("stop()");
        try {
            this.getTorque().shutdown();
        }
        catch (Exception e) {
            this.getLogger().error("Error while stopping Torque", (Throwable)e);
        }
    }

    public boolean isInit() {
        return this.getTorque().isInit();
    }

    public org.apache.commons.configuration.Configuration getConfiguration() {
        return this.getTorque().getConfiguration();
    }

    public AbstractBaseManager getManager(String name) {
        return this.getTorque().getManager(name);
    }

    public AbstractBaseManager getManager(String name, String defaultClassName) {
        return this.getTorque().getManager(name, defaultClassName);
    }

    public DatabaseMap getDatabaseMap() throws TorqueException {
        return this.getTorque().getDatabaseMap();
    }

    public DatabaseMap getDatabaseMap(String name) throws TorqueException {
        return this.getTorque().getDatabaseMap(name);
    }

    public void registerMapBuilder(String className) {
        this.getTorque().registerMapBuilder(className);
    }

    public Connection getConnection() throws TorqueException {
        return this.getTorque().getConnection();
    }

    public Connection getConnection(String name) throws TorqueException {
        return this.getTorque().getConnection(name);
    }

    public Connection getConnection(String name, String username, String password) throws TorqueException {
        return this.getTorque().getConnection(name, username, password);
    }

    public DB getDB(String name) throws TorqueException {
        return this.getTorque().getDB(name);
    }

    public String getDefaultDB() {
        return this.getTorque().getDefaultDB();
    }

    public void closeConnection(Connection con) {
        this.getTorque().closeConnection(con);
    }
}

