/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CacheUtils {
    private CacheUtils() {
    }

    public static Serializable dup(Serializable obj) throws IOException {
        return CacheUtils.deserialize(CacheUtils.serialize(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    public static Serializable deserialize(byte[] buf) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
        finally {
            ois.close();
        }
    }
}

