/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheFailoverRunner;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.engine.behavior.ICacheElement;

public class RemoteCacheNoWaitFacade
implements AuxiliaryCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade = RemoteCacheNoWaitFacade.class$("org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade));
    public RemoteCacheNoWait[] noWaits;
    private String cacheName;
    RemoteCacheAttributes rca;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWaitFacade;

    public RemoteCacheAttributes getRemoteCacheAttributes() {
        return this.rca;
    }

    public void setRemoteCacheAttributes(RemoteCacheAttributes rca) {
        this.rca = rca;
    }

    public RemoteCacheNoWaitFacade(RemoteCacheNoWait[] noWaits, RemoteCacheAttributes rca) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CONSTRUCTING NO WAIT FACADE");
        }
        this.noWaits = noWaits;
        this.rca = rca;
        this.cacheName = rca.getCacheName();
    }

    public void update(ICacheElement ce) throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating through cache facade, noWaits.length = " + this.noWaits.length));
        }
        try {
            for (i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].update(ce);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
            this.failover(i);
        }
    }

    public ICacheElement get(Serializable key) {
        int i = 0;
        if (i < this.noWaits.length) {
            try {
                ICacheElement obj = this.noWaits[i].get(key);
                if (obj != null) {
                    return obj;
                }
            }
            catch (Exception ex) {
                log.debug((Object)"Failed to get.");
            }
            return null;
        }
        return null;
    }

    public Set getGroupKeys(String group) {
        HashSet allKeys = new HashSet();
        for (int i = 0; i < this.noWaits.length; ++i) {
            RemoteCacheNoWait aux = this.noWaits[i];
            if (aux == null) continue;
            allKeys.addAll(aux.getGroupKeys(group));
        }
        return allKeys;
    }

    public boolean remove(Serializable key) {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].remove(key);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return false;
    }

    public void removeAll() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].removeAll();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void dispose() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return "";
    }

    public int getStatus() {
        return 0;
    }

    public String toString() {
        return "RemoteCacheNoWaitFacade: " + this.cacheName + ", rca = " + this.rca;
    }

    protected void failover(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("in failover for " + i));
        }
        if (this.rca.getRemoteType() == 0) {
            if (this.noWaits[i].getStatus() == 3) {
                RemoteCacheFailoverRunner runner = new RemoteCacheFailoverRunner(this);
                if (runner != null) {
                    runner.notifyError();
                    Thread t = new Thread(runner);
                    t.setDaemon(true);
                    t.start();
                }
            } else {
                log.info((Object)"the noWait is not in error");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

