/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.transform.XmlToAppData;
import org.apache.torque.task.TorqueDataModelTask;
import org.apache.velocity.context.Context;

public class TorqueSQLTask
extends TorqueDataModelTask {
    private String database;
    private String suffix = "";
    private String idTableXMLFile = null;

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setIdTableXMLFile(String idXmlFile) {
        this.idTableXMLFile = idXmlFile;
    }

    public String getIdTableXMLFile() {
        return this.idTableXMLFile;
    }

    private void createSqlDbMap() throws Exception {
        if (this.getSqlDbMap() == null) {
            return;
        }
        Properties sqldbmap = new Properties();
        File file = new File(this.getSqlDbMap());
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            sqldbmap.load(fis);
            fis.close();
        }
        Iterator i = this.getDataModelDbMap().keySet().iterator();
        while (i.hasNext()) {
            String dataModelName = (String)i.next();
            String sqlFile = dataModelName + this.suffix + ".sql";
            String databaseName = this.getDatabase() == null ? (String)this.getDataModelDbMap().get(dataModelName) : this.getDatabase();
            sqldbmap.setProperty(sqlFile, databaseName);
        }
        sqldbmap.store(new FileOutputStream(this.getSqlDbMap()), "Sqlfile -> Database map");
    }

    public void loadIdBrokerModel() throws EngineException {
        XmlToAppData xmlParser = new XmlToAppData(this.getTargetDatabase(), null);
        Database ad = xmlParser.parseFile(this.getIdTableXMLFile());
        ad.setName("idmodel");
        this.context.put("idmodel", (Object)ad);
    }

    public Context initControlContext() throws Exception {
        super.initControlContext();
        try {
            this.createSqlDbMap();
            String f = this.getIdTableXMLFile();
            if (f != null && f.length() > 0) {
                this.loadIdBrokerModel();
            }
        }
        catch (EngineException ee) {
            throw new BuildException((Throwable)((Object)ee));
        }
        return this.context;
    }
}

