/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.SchemaType;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.torque.engine.platform.Platform;
import org.xml.sax.Attributes;

public class Domain {
    private String name;
    private String description;
    private String size;
    private String scale;
    private SchemaType torqueType;
    private String sqlType;
    private String defaultValue;

    public Domain() {
        this.name = null;
    }

    public Domain(String name) {
        this.name = name;
    }

    public Domain(SchemaType type) {
        this.name = null;
        this.torqueType = type;
        this.sqlType = type.getName();
    }

    public Domain(SchemaType type, String sqlType) {
        this.name = null;
        this.torqueType = type;
        this.sqlType = sqlType;
    }

    public Domain(SchemaType type, String sqlType, String size, String scale) {
        this.name = null;
        this.torqueType = type;
        this.sqlType = sqlType;
        this.size = size;
        this.scale = scale;
    }

    public Domain(SchemaType type, String sqlType, String size) {
        this.name = null;
        this.torqueType = type;
        this.sqlType = sqlType;
        this.size = size;
    }

    public Domain(Domain domain) {
        this.copy(domain);
    }

    public void copy(Domain domain) {
        this.defaultValue = domain.getDefaultValue();
        this.description = domain.getDescription();
        this.name = domain.getName();
        this.scale = domain.getScale();
        this.size = domain.getSize();
        this.sqlType = domain.getSqlType();
        this.torqueType = domain.getType();
    }

    public void loadFromXML(Attributes attrib, Platform platform) {
        SchemaType schemaType = SchemaType.getEnum(attrib.getValue("type"));
        this.copy(platform.getDomainForSchemaType(schemaType));
        this.name = attrib.getValue("name");
        this.defaultValue = attrib.getValue("default");
        this.size = attrib.getValue("size");
        this.scale = attrib.getValue("scale");
        this.description = attrib.getValue("description");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScale() {
        return this.scale;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void replaceScale(String value) {
        this.scale = StringUtils.defaultString((String)value, (String)this.getScale());
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void replaceSize(String value) {
        this.size = StringUtils.defaultString((String)value, (String)this.getSize());
    }

    public SchemaType getType() {
        return this.torqueType;
    }

    public void setType(SchemaType torqueType) {
        this.torqueType = torqueType;
    }

    public void setType(String torqueType) {
        this.torqueType = SchemaType.getEnum(torqueType);
    }

    public void replaceType(String value) {
        this.torqueType = SchemaType.getEnum(StringUtils.defaultString((String)value, (String)this.getType().getName()));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultSetting() {
        StringBuffer dflt = new StringBuffer(0);
        if (this.getDefaultValue() != null) {
            dflt.append("default ");
            if (TypeMap.isTextType(this.getType())) {
                dflt.append('\'').append(this.getDefaultValue()).append('\'');
            } else {
                dflt.append(this.getDefaultValue());
            }
        }
        return dflt.toString();
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void replaceDefaultValue(String value) {
        this.defaultValue = StringUtils.defaultString((String)value, (String)this.getDefaultValue());
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String printSize() {
        if (this.size != null && this.scale != null) {
            return '(' + this.size + ',' + this.scale + ')';
        }
        if (this.size != null) {
            return '(' + this.size + ')';
        }
        return "";
    }
}

