"""
Copyright (c) 2006, www.everes.net
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the everes nor the names of its contributors may be 
      used to endorse or promote products derived from this software without 
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""
from django.conf.urls.defaults import *
from django.conf.settings import WORKSTYLE_MEDIA_ROOT

urlpatterns = patterns('',
    # Example:
    # (r'^WorkStyle/', include('WorkStyle.apps.foo.urls.foo')),
    (r'^$', 'WorkStyle.apps.workstyle.task.top'),
    (r'^TaskList/$', 'WorkStyle.apps.workstyle.task.list_default'),
    (r'^TaskList/rss/(?P<sort_type>\d+)/(?P<sort_order>\d+)/(?P<status_list>\S+)/(?P<tag_list>\S+)/(?P<offset>\d+)/(?P<limit>\d+)/(?P<key>\S+)/$', 'WorkStyle.apps.workstyle.task.list_rss'),
    (r'^TaskList/atom/(?P<sort_type>\d+)/(?P<sort_order>\d+)/(?P<status_list>\S+)/(?P<tag_list>\S+)/(?P<offset>\d+)/(?P<limit>\d+)/(?P<key>\S+)/$', 'WorkStyle.apps.workstyle.task.list_atom'),
    (r'^TaskList/(?P<sort_type>\d+)/(?P<sort_order>\d+)/(?P<status_list>\S+)/(?P<tag_list>\S+)/(?P<offset>\d+)/(?P<limit>\d+)/(?P<key>\S+)/$', 'WorkStyle.apps.workstyle.task.list'),
    (r'^TaskList/update_status/(?P<task_id>\d+)/(?P<status>\d+)/(?P<sort_type>\d+)/(?P<sort_order>\d+)/(?P<status_list>\S+)/(?P<tag_list>\S+)/(?P<offset>\d+)/(?P<limit>\d+)/(?P<key>\S+)/$', 'WorkStyle.apps.workstyle.task.list_update_status'),
    (r'^TaskList/delete_task/(?P<task_id>\d+)/(?P<sort_type>\d+)/(?P<sort_order>\d+)/(?P<status_list>\S+)/(?P<tag_list>\S+)/(?P<offset>\d+)/(?P<limit>\d+)/(?P<key>\S+)/$', 'WorkStyle.apps.workstyle.task.list_delete_task'),
    (r'^Task/(?P<task_id>\d+)/$', 'WorkStyle.apps.workstyle.task.index'),
    (r'^Task/(?P<task_id>\d+)/update_status/(?P<status>\d+)/$', 'WorkStyle.apps.workstyle.task.update_status'),
    (r'^Task/(?P<task_id>\d+)/add_tag/(?P<tag_id>\d+)/$', 'WorkStyle.apps.workstyle.task.add_tag'),
    (r'^Task/(?P<task_id>\d+)/remove_tag/(?P<tag_id>\d+)/$', 'WorkStyle.apps.workstyle.task.remove_tag'),
    (r'^Task/new/$', 'WorkStyle.apps.workstyle.task.create_task'),
    (r'^Task/add/$', 'WorkStyle.apps.workstyle.task.create_task'),
    (r'^Task/(?P<task_id>\d+)/edit/$', 'WorkStyle.apps.workstyle.task.edit_task'),
    (r'^Task/(?P<task_id>\d+)/update/$', 'WorkStyle.apps.workstyle.task.edit_task'),
    (r'^Task/(?P<task_id>\d+)/delete/$', 'WorkStyle.apps.workstyle.task.delete'),
    (r'^Task/(?P<task_id>\d+)/delete_attachment/(?P<attachment_id>\d+)/$', 'WorkStyle.apps.workstyle.task.attachment_delete'),
    (r'^Tag/$', 'WorkStyle.apps.workstyle.tag.index'),
    (r'^Tag/(?P<tag_id>\d+)/select_type/(?P<type_id>\d+)/$', 'WorkStyle.apps.workstyle.tag.select_type'),
    (r'^Tag/(?P<tag_id>\d+)/switch_visible/(?P<visible_flag>\w+)/$', 'WorkStyle.apps.workstyle.tag.switch_visible'),
    (r'^Tag/(?P<tag_id>\d+)/delete/$', 'WorkStyle.apps.workstyle.tag.delete'),
    (r'^resources/(?P<path>.*)','django.views.static.serve', {'document_root' : WORKSTYLE_MEDIA_ROOT, 'show_indexes':False}),

    # Uncomment this for admin:
    # (r'^admin/', include('django.contrib.admin.urls.admin')),
)
