"""
Copyright (c) 2006, www.everes.net
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the everes nor the names of its contributors may be 
      used to endorse or promote products derived from this software without 
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""
# Create your views here.
from django.core.extensions import render_to_response
from django.utils.httpwrappers import HttpResponseRedirect
from django.core.extensions import get_object_or_404, Http404, ObjectDoesNotExist
from django.models.workstyle import tags, taglists, tasks, Tag, TAG_TYPE_CHOICES, TASK_STATUS
from WorkStyle.settings import WORKSTYLE_ROOT

def index(request):
    tag_list = tags.get_list()
    tag_type = getTagTypeList()

    return render_to_response('workstyle/TagList', {'tag_list': tag_list, 'tag_type': tag_type, 'workstyle_root': WORKSTYLE_ROOT })

def select_type(request, tag_id, type_id):
    try:
        tag = tags.get_object(pk=tag_id)
    except ObjectDoesNotExist :
        raise Http404
    #tag = get_object_or_404(Tag, pk=tag_id)
    tag.tag_type = type_id
    tag.save()
    return HttpResponseRedirect(WORKSTYLE_ROOT + '/Tag/')

def switch_visible(request, tag_id, visible_flag):
    try:
        tag = tags.get_object(pk=tag_id)
    except ObjectDoesNotExist :
        raise Http404
    if visible_flag == 'on' :
        tag.visible = True
    else :
        tag.visible = False
    tag.save()
    return HttpResponseRedirect(WORKSTYLE_ROOT + '/Tag/')

def delete(request, tag_id):
    try:
        tag = tags.get_object(pk=tag_id)
    except ObjectDoesNotExist :
        raise Http404
    taglist_list = tag.get_taglist_list()
    tag.delete()

    task_id_list = ""
    for taglist in taglist_list :
        task_id_list += "%d," % taglist.task_id
    if task_id_list != "" :
        task_id_list = task_id_list.rstrip(",")
        task_list = tasks.get_list(id__in=[task_id_list])
        for task in task_list :
            recreateTask(task.id)
    return HttpResponseRedirect(WORKSTYLE_ROOT + '/Tag/')


def getStatusList():
    status_list = []
    for task_status in TASK_STATUS:
        status_list.append(TaskStatus(task_status[0], task_status[1], task_status[2]))
    return status_list

def getTagTypeList():
    tag_type = []
    for type in TAG_TYPE_CHOICES:
        tag_type.append(TagType(type[0], type[1]))
    return tag_type

def recreateTask(task_id) :
    try :
        task = tasks.get_object(pk=task_id)
    except ObjectDoesNotExist :
        raise Http404
    task_tag_list = task.get_taglist_list(select_related=True)
    searchable_tag = ""
    for task_tag in task_tag_list :
        t = task_tag.get_tag()
        searchable_tag += "	%s" % t.name
    task.tag_searchable = searchable_tag
    task.save()



class TagType:
    id=0
    name=""
    def __init__(self, id, name):
        self.id = id
        self.name = name

class TaskStatus:
    id=0
    name=""
    icon=""
    selected = False
    id_str = ""
    def __init__(self, id, name, icon):
        self.id = id
        self.name = name
        self.icon = icon
        self.id_str = str(self.id)
