﻿
window.wordring = {
	socket: null, // TMとの通信用ソケット。
	port: 1, // ソケットのポート番号。
	url: '',
	edit_mode: false, // 編集モード判別フラグ。
		
	segments: null, // パラグラフの連想配列。
	
	// ページのセットアップを行う。
	setup: function() {
		if(!window.WebSocket) alert('Your browser does not support websocket.\r\nBecause wordring-tm needs it, you must use the latest browser.');
		// 原文のコピーを取る。
		wordring.segments = Array();
		var elements = document.getElementsByTagName('span');
		var element;
		var i = 0;
		for(; i < elements.length ; i++)
		{
			element = elements.item(i);
			if(!element.hasAttribute('data-wordring-segment')) continue;
			
			var id = element.getAttribute('data-wordring-segment');
			var segment = {};
			segment.segment_id = id;
			segment.loaded = false;
			segment.element = element;
			segment.html = element.innerHTML;
			wordring.segments[id] = segment;
		}
		
		wordring.socket = new WebSocket('ws://localhost:' + window.wordring.port + '/');
		wordring.socket.onopen = wordring.onopen;
		wordring.socket.onmessage = wordring.onmessage;
		wordring.socket.onerror = wordring.onerror;
		wordring.socket.onclose = wordring.onclose;
	},
	
	onopen: function(ev) {
		document.addEventListener('click', wordring.onclick);
		window.addEventListener('focus', wordring.onfocus);
		window.addEventListener('blur', wordring.onblur);
		
		wordring.socket.send(JSON.stringify({
			'cmd': 'load',
			'url': window.wordring.url
		}));
		
		// 全てのセグメントの対して、セグメントの情報を送信する。
		var length = wordring.segments.length;
		var i = 0;
		for(; i < length; i++) {
			var segment = wordring.segments[i];
			wordring.socket.send(JSON.stringify({
				'cmd': 'load_segment',
				'segment_id': segment.segment_id,
				'html': segment.html
			}));
		}
	},
	
	onmessage: function(ev) {
		var json = JSON.parse(ev.data);
		switch(json.cmd)
		{
		case 'set_segment': wordring.set_segment(json); break;
		case 'set_edit_mode': wordring.set_edit_mode(json); break;
		case 'segment_loaded': wordring.segment_loaded(json); break;
		case 'reload': wordring.reload(); break;
		}
	},
	
	onerror: function(ev) {
		//document.location.href = 'http://www.yahoo.co.jp/';
	},
	
	onclose: function(ev) {
		window.location.href = 'http://wordring.net/';
	},
	
	onfocus: function(ev) {
		wordring.socket.send(JSON.stringify({
			'cmd': 'focus'
		}));
	},
	
	onblur: function(e) {
		wordring.socket.send(JSON.stringify({
			'cmd': 'blur'
		}));

	},
	
	onclick: function(ev) {
		if(!wordring.edit_mode) return;
		ev.preventDefault();
		var node;
		for(node = ev.target; node.nodeType == Node.ELEMENT_NODE; node = node.parentNode) {
			if(node.hasAttribute('data-wordring-segment'))
			{
				var id = node.getAttribute('data-wordring-segment');
				var segment = wordring.segments[id];
				if(segment.loaded) break;
				wordring.socket.send(JSON.stringify({
					'cmd': 'edit_segment',
					'segment_id': segment.segment_id
				}));
				break;
			}
		}
	},
	
	set_segment: function(json) {
		var segment_id = json.segment_id;
		wordring.segments[segment_id].element.innerHTML = json.html;
	},
	
	set_edit_mode: function(json) {
		wordring.edit_mode = json.edit_mode;
	},
	
	segment_loaded: function(json) {
		var segment_id = json.segment_id;
		var segment = wordring.segments[segment_id];
		segment.loaded = true;
		segment.element.className = '';
	},
	
	reload: function() {
		window.location.reload();
	}
};

if(document.addEventListener)
{
	window.addEventListener('load', function(ev){ 
		wordring.setup();
	});	
} else {
	window.attachEvent('onload', function(ev){ 
		wordring.setup();
	});
}


