/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import junit.framework.TestCase;
import woolpack.adapter.HSQLDBUtils;
import woolpack.fn.FnUtils;
import woolpack.sql.fn.SqlFnUtils;
import woolpack.sql.tx.SqlTxUtils;
import woolpack.sql.tx.TxBuilder;

public class TxBuilderTest extends TestCase {
	
	public void testOutOfBounds() {
		final TxBuilder builder = new TxBuilder(HSQLDBUtils.getDataSource(false));
		try {
			builder.getTmpDataSource().getConnection();
			fail();
		} catch (final SQLException e) {
			assertEquals("transaction not start.", e.getMessage());
		}
	}

	public void testDoubleRollback0() throws SQLException {
		final TxBuilder builder = new TxBuilder(HSQLDBUtils.getDataSource(false));
		final Connection connection = builder.getTxDataSource().getConnection();
		try {
			connection.rollback();
			try {
				builder.getTmpDataSource().getConnection();
				fail();
			} catch (final SQLException e) {
				assertEquals("already rollbacked.", e.getMessage());
			}
		} finally {
			connection.close();
		}
	}

	public void testDoubleRollback1() throws SQLException {
		final TxBuilder builder = new TxBuilder(HSQLDBUtils.getDataSource(false));
		final Connection connection = builder.getTxDataSource().getConnection();
		try {
			final Connection tmpConnection = builder.getTmpDataSource().getConnection();
			try {
				tmpConnection.rollback();
			} finally {
				tmpConnection.close();
			}
			try {
				builder.getTmpDataSource().getConnection();
				fail();
			} catch (final SQLException e) {
				assertEquals("already rollbacked.", e.getMessage());
			}
		} finally {
			connection.close();
		}
	}

	public void testCloseAll() throws Exception {
		final TxBuilder builder = new TxBuilder(HSQLDBUtils.getDataSource(false));
		
		assertEquals(Integer.valueOf(0), SqlTxUtils.tx(builder.getTxDataSource(),
				SqlFnUtils.inputStatement(
						builder.getTmpDataSource(),
						"create memory table my_table (" +
						"my_id integer, " +
						"my_seq integer, " +
						"my_string varchar, " +
						"my_int integer, " +
						"constraint MYTALBE0P primary key (my_id, my_seq))",
						SqlFnUtils.GET_COUNT,
						FnUtils.fix(null))
		).exec(null));
		
		final Connection connection = builder.getTxDataSource().getConnection();
		try {
			final Connection tmpConnection = builder.getTmpDataSource().getConnection();
			final Statement statement = tmpConnection.createStatement();
			statement.executeQuery(
					"select my_string from my_table where my_id = 0 and my_seq = 2");
			tmpConnection.prepareStatement(
					"select my_string from my_table where my_id = ? and my_seq = ?");
		} finally {
			connection.close();
		}
	}
}
