/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;

import woolpack.test.TestBean;
import woolpack.utils.Utils;

import junit.framework.TestCase;

public class ThisELTest extends TestCase {
	public void testSetValueMap() {
		final Map<String, Object> before = Utils.<String, Object>map("k0", "v0").map("k1", "v1");
		final Map<String, Object> after = new HashMap<String, Object>();
		ELUtils.THIS.setValue(after, before);
		final Map<String, Object> expected = Utils.<String, Object>map("k0", "v0").map("k1", "v1");
		assertEquals(expected, before);
		assertEquals(expected, after);
	}

	public void testSetValueBean() {
		final Map<String, Object> before = Utils.<String, Object>map("myInt", "13");
		final TestBean after = new TestBean();
		ELUtils.THIS.setValue(after, before);
		assertEquals(13, after.getMyInt());
	}
}
