/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.util.concurrent.atomic.AtomicInteger;

import javax.sql.DataSource;

import org.hsqldb.jdbc.jdbcDataSource;

import woolpack.sql.adapter.AutoCommitSettingDataSource;

/**
 * HSQLDBのユーティリティです。
 * 本クラスは HSQLDB のライブラリを使用します。
 * <br/>適用しているデザインパターン：{@link DataSource}のFactory Method。
 * @author nakamura
 *
 */
public final class HSQLDBUtils {
	private static AtomicInteger count = new AtomicInteger();
	
	private HSQLDBUtils() {
	}

	/**
	 * HSQLDBのメモリDBへの{@link DataSource}を返します。
	 * @param autoCommit 自動コミットする場合はtrue。
	 * @return HSQLDBのメモリDBへの{@link DataSource}。
	 */
	public static DataSource getDataSource(final boolean autoCommit) {
		final jdbcDataSource dataSource = new jdbcDataSource();
		dataSource.setDatabase("jdbc:hsqldb:mem:HSQLDBUtils" + count.addAndGet(1));
		dataSource.setUser("sa");
		dataSource.setPassword("");
		return new AutoCommitSettingDataSource(dataSource, autoCommit);
	}
}
