/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.bool.BoolUtilsTest;
import woolpack.convert.ConvertUtilsTest;
import woolpack.ee.HttpSessionMapTest;
import woolpack.ee.ServletContextMapTest;
import woolpack.ee.ServletRequestAttributeMapTest;
import woolpack.el.ArrayPathELTest;
import woolpack.el.CachePropertyELFactoryTest;
import woolpack.el.FixELTest;
import woolpack.el.MaybeELTest;
import woolpack.el.NullELTest;
import woolpack.el.PathELTest;
import woolpack.el.PropertyELTest;
import woolpack.factory.FactoryUtilsTest;
import woolpack.fn.FnUtilsTest;
import woolpack.id.IdUtilsTest;
import woolpack.idweb.IdWebUtilsTest;
import woolpack.misc.MiscUtilsTest;
import woolpack.sql.SqlCommentUtilsTest;
import woolpack.sql.SqlFnUtilsTest;
import woolpack.sql.TxBuilderTest;
import woolpack.sql.adapter.ConnectionAdapterTest;
import woolpack.sql.adapter.DataSourceAdapterTest;
import woolpack.sql.adapter.PreparedStatementAdapterTest;
import woolpack.sql.adapter.ResultSetAdapterTest;
import woolpack.sql.adapter.StatementAdapterTest;
import woolpack.typeconvert.DelegationIfNecessityConverterTest;
import woolpack.typeconvert.ToTypeConverterTest;
import woolpack.typeconvert.TypeConvertUtilsTest;
import woolpack.utils.UtilsAllTests;
import woolpack.validator.AddressedMessageCollectorTest;
import woolpack.validator.AddressedMessageTest;
import woolpack.validator.NameBranchIfExistsTest;
import woolpack.validator.NameBranchIfNotEmptyTest;
import woolpack.validator.NameBranchTest;
import woolpack.validator.SimpleMessageCollectorTest;
import woolpack.validator.ValidatorContextTest;
import woolpack.validator.ValidatorUtilsTest;
import woolpack.validator.ValueLoopValidatorTest;
import woolpack.web.WebUtilsTest;

public class AllTests extends TestCase {
	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(UtilsAllTests.suite());

		suite.addTest(new TestSuite(AccessorTest.class));
		suite.addTest(new TestSuite(BoolUtilsTest.class));
		suite.addTest(new TestSuite(ConvertUtilsTest.class));
		suite.addTest(new TestSuite(FactoryUtilsTest.class));
		suite.addTest(new TestSuite(FnUtilsTest.class));
		suite.addTest(new TestSuite(IdUtilsTest.class));
		suite.addTest(new TestSuite(IdWebUtilsTest.class));
		suite.addTest(new TestSuite(MiscUtilsTest.class));
		suite.addTest(new TestSuite(WebUtilsTest.class));

		// validator
		suite.addTest(new TestSuite(AddressedMessageCollectorTest.class));
		suite.addTest(new TestSuite(AddressedMessageTest.class));
		suite.addTest(new TestSuite(NameBranchTest.class));
		suite.addTest(new TestSuite(NameBranchIfExistsTest.class));
		suite.addTest(new TestSuite(NameBranchIfNotEmptyTest.class));
		suite.addTest(new TestSuite(SimpleMessageCollectorTest.class));
		suite.addTest(new TestSuite(ValidatorUtilsTest.class));
		suite.addTest(new TestSuite(ValidatorContextTest.class));
		suite.addTest(new TestSuite(ValueLoopValidatorTest.class));

		// typeconvert
		suite.addTest(new TestSuite(DelegationIfNecessityConverterTest.class));
		suite.addTest(new TestSuite(TypeConvertUtilsTest.class));
		suite.addTest(new TestSuite(ToTypeConverterTest.class));
		
		// el
		suite.addTest(new TestSuite(ArrayPathELTest.class));
		suite.addTest(new TestSuite(CachePropertyELFactoryTest.class));
		suite.addTest(new TestSuite(FixELTest.class));
		suite.addTest(new TestSuite(MaybeELTest.class));
		suite.addTest(new TestSuite(NullELTest.class));
		suite.addTest(new TestSuite(PropertyELTest.class));
		suite.addTest(new TestSuite(PathELTest.class));	

		// ee
		suite.addTest(new TestSuite(HttpSessionMapTest.class));
		suite.addTest(new TestSuite(ServletContextMapTest.class));
		suite.addTest(new TestSuite(ServletRequestAttributeMapTest.class));

		// sql
		suite.addTest(new TestSuite(SqlCommentUtilsTest.class));
		suite.addTest(new TestSuite(SqlFnUtilsTest.class));
		suite.addTest(new TestSuite(TxBuilderTest.class));
		
		// sql.adapter
		suite.addTest(new TestSuite(ConnectionAdapterTest.class));
		suite.addTest(new TestSuite(DataSourceAdapterTest.class));
		suite.addTest(new TestSuite(PreparedStatementAdapterTest.class));
		suite.addTest(new TestSuite(ResultSetAdapterTest.class));
		suite.addTest(new TestSuite(StatementAdapterTest.class));

		return suite;
	}

	public static void main(final String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
