/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Iterable<String> getGuessingIterable(final String s, final char separator) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final HashSet<String> set = new HashSet<String>();
                set.add(s);
                return new Iterator<String>(){
                    private int i = 0;
                    private String tmpString;
                    {
                        this.tmpString = string;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.tmpString != null;
                    }

                    @Override
                    public String next() {
                        String returnString = this.tmpString;
                        do {
                            switch (this.i) {
                                case 0: {
                                    this.tmpString = s;
                                    break;
                                }
                                case 1: {
                                    this.tmpString = s.toLowerCase();
                                    break;
                                }
                                case 2: {
                                    this.tmpString = s.toUpperCase();
                                    break;
                                }
                                case 3: {
                                    this.tmpString = PropertyUtils.toSQLName(s, separator);
                                    break;
                                }
                                case 4: {
                                    this.tmpString = this.tmpString.toLowerCase();
                                    break;
                                }
                                case 5: {
                                    this.tmpString = PropertyUtils.sqlWordHeadToUpper(this.tmpString);
                                    break;
                                }
                                case 6: {
                                    this.tmpString = PropertyUtils.toJavaName(s, separator);
                                    break;
                                }
                                case 7: {
                                    this.tmpString = String.valueOf(Character.toUpperCase(this.tmpString.charAt(0))) + this.tmpString.substring(1);
                                    break;
                                }
                                case 8: {
                                    this.tmpString = this.tmpString.toLowerCase();
                                    break;
                                }
                                case 9: {
                                    this.tmpString = this.tmpString.toUpperCase();
                                    break;
                                }
                                default: {
                                    this.tmpString = null;
                                }
                            }
                            ++this.i;
                        } while (set.contains(this.tmpString));
                        if (this.tmpString != null) {
                            set.add(this.tmpString);
                        }
                        return returnString;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static String sqlWordHeadToUpper(String s) {
        StringBuilder sb = new StringBuilder(s);
        boolean flag = false;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (flag || i == 0) {
                sb.setCharAt(i, Character.toUpperCase(c));
                flag = false;
            }
            if (c == '_') {
                flag = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Iterable<String> getGuessingIterable(String s) {
        return PropertyUtils.getGuessingIterable(s, '_');
    }

    public static String toJavaName(String s) {
        return PropertyUtils.toJavaName(s, '_');
    }

    public static String toJavaName(String s, char separator) {
        if (s == null || s.indexOf(separator) < 0) {
            if (s != null && s.length() >= 1) {
                return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        boolean separateFlag = false;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c == separator) {
                separateFlag = true;
                sb.delete(i, i + 1);
                continue;
            }
            if (separateFlag) {
                c = Character.toUpperCase(c);
                separateFlag = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sb.setCharAt(i, c);
            ++i;
        }
        return sb.toString();
    }

    public static String toSQLName(String s) {
        return PropertyUtils.toSQLName(s, '_');
    }

    public static String toSQLName(String s, char separator) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int length = s.length();
        boolean upper = false;
        int i = length - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c) && upper) {
                sb.insert(0, separator);
            }
            upper = Character.isUpperCase(c);
            sb.insert(0, Character.toUpperCase(c));
            --i;
        }
        return sb.toString();
    }
}

