/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;
import woolpack.typeconvert.TypeConvertUtils;
import woolpack.utils.AbstractKeyIteratorMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMap
extends AbstractKeyIteratorMap<String, Object> {
    private final Object object;
    private final Fn<ConvertContext, Void, ? extends RuntimeException> fn;
    private final Map<String, PropertyDescriptor> map;
    private final Set<String> set;

    public BeanMap(Object object) {
        this(object, TypeConvertUtils.COLLECTION_CONVERTER);
    }

    public BeanMap(Object object, Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
        BeanInfo beanInfo;
        this.object = object;
        this.fn = fn;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        PropertyDescriptor[] array = beanInfo.getPropertyDescriptors();
        this.map = new HashMap<String, PropertyDescriptor>(array.length);
        PropertyDescriptor[] propertyDescriptorArray = array;
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            PropertyDescriptor p = propertyDescriptorArray[n];
            String key = p.getName();
            if (!"class".equals(key)) {
                this.map.put(key, p);
            }
            ++n;
        }
        this.set = Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return this.set.iterator();
    }

    @Override
    protected Object getValue(Object key) {
        Method m;
        PropertyDescriptor p = this.map.get(key);
        if (p != null && (m = p.getReadMethod()) != null) {
            try {
                return m.invoke(this.object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("error at " + key, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("error at " + key, e);
            }
        }
        throw new IllegalStateException("property" + key + " not found.");
    }

    @Override
    public Object put(String key, Object value) {
        Method m;
        PropertyDescriptor p = this.map.get(key);
        if (p != null && (m = p.getWriteMethod()) != null) {
            try {
                ConvertContext c = new ConvertContext();
                c.setPropertyName(key);
                c.setToType(p.getPropertyType());
                c.setValue(value);
                this.fn.exec(c);
                return m.invoke(this.object, c.getValue());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("error at " + key, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("error at " + key, e);
            }
        }
        throw new IllegalStateException("property" + key + " not found.");
    }
}

