/*
 * Decompiled with CFR 0.152.
 */
package woolpack.test;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtils {
    private static final Pattern QUERY = Pattern.compile("[\\?&]?([^=\\?]+)=([^&]*)");

    private TestUtils() {
    }

    private static void addTo(Map<String, List<Object>> result, String key, String value) {
        List<Object> list = result.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            result.put(key, list);
        }
        list.add(value);
    }

    public static Map<String, List<Object>> selectQuery(String query) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        Matcher m = QUERY.matcher(query);
        while (m.find()) {
            TestUtils.addTo(result, m.group(1), m.group(2));
        }
        return result;
    }

    private static String getText(Node node) {
        StringBuilder sb = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeType() == 3) {
                sb.append(nodeList.item(i).getNodeValue());
            }
            ++i;
        }
        return sb.toString();
    }

    private static void selectForm(Node node, Map<String, List<Object>> result, String selectName) {
        String name;
        if (node.getNodeType() == 1) {
            String value;
            Element e = (Element)node;
            String elementName = e.getNodeName();
            if ("OPTION".equals(elementName)) {
                name = selectName;
                value = e.hasAttribute("selected") ? e.getAttribute("value") : null;
            } else if (e.hasAttribute("name")) {
                String inputType;
                name = e.getAttribute("name");
                value = "SELECT".equals(elementName) ? null : ("INPUT".equals(elementName) ? ("radio".equals(inputType = e.getAttribute("type")) || "checkbox".equals(inputType) ? (e.hasAttribute("checked") ? (e.hasAttribute("value") ? e.getAttribute("value") : "") : null) : (e.hasAttribute("value") ? e.getAttribute("value") : "")) : ("BUTTON".equals(elementName) ? (e.hasAttribute("value") ? e.getAttribute("value") : "") : TestUtils.getText(e)));
            } else {
                name = selectName;
                value = null;
            }
            if (value != null) {
                TestUtils.addTo(result, name, value);
            }
        } else {
            name = null;
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                TestUtils.selectForm(n, result, name);
            }
            ++i;
        }
    }

    public static Map<String, List<Object>> selectForm(Node node) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        TestUtils.selectForm(node, result, null);
        return result;
    }

    public static Map<String, List<Object>> selectEmbedded(Iterable<String> attrNames, Node node) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        TestUtils.selectEmbedded(attrNames, node, result);
        return result;
    }

    private static void selectEmbedded(Iterable<String> attrNames, Node node, Map<String, List<Object>> result) {
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            for (String attrName : attrNames) {
                if (!e.hasAttribute(attrName)) continue;
                TestUtils.addTo(result, e.getAttribute(attrName), TestUtils.getText(e));
                break;
            }
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            TestUtils.selectEmbedded(attrNames, nodeList.item(i), result);
            ++i;
        }
    }

    public static String toString(Reader reader) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while ((i = reader.read()) >= 0) {
                sb.append((char)i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static boolean equals(Object a, Object b) {
        boolean result = TestUtils.equalsPrivate(a, b);
        if (!result) {
            PrintStream stream = System.out;
            stream.print("-- equals start -- expected --");
            stream.print(a);
            stream.print("-- but --");
            stream.print(b);
            stream.println("-- equals end --");
        }
        return result;
    }

    private static boolean equalsPrivate(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof LinkedHashMap && b instanceof LinkedHashMap) {
            LinkedHashMap aMap = (LinkedHashMap)a;
            LinkedHashMap bMap = (LinkedHashMap)b;
            if (!TestUtils.equalsMap(aMap, bMap)) {
                return false;
            }
            Iterator aIterator = aMap.keySet().iterator();
            Iterator bIterator = bMap.keySet().iterator();
            while (aIterator.hasNext()) {
                if (TestUtils.equalsPrivate(aIterator.next(), bIterator.next())) continue;
                return false;
            }
            return true;
        }
        if (a instanceof Map) {
            if (b instanceof Map) {
                Map aMap = (Map)a;
                Map bMap = (Map)b;
                return TestUtils.equalsMap(aMap, bMap);
            }
            return false;
        }
        if (b instanceof Map) {
            return false;
        }
        if ((a instanceof List || a.getClass().isArray()) && (b instanceof List || a.getClass().isArray())) {
            List<?> aList = Utils.toList(a);
            List<?> bList = Utils.toList(b);
            if (aList.size() != bList.size()) {
                return false;
            }
            int length = aList.size();
            int i = 0;
            while (i < length) {
                if (!TestUtils.equalsPrivate(aList.get(i), bList.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (a instanceof Collection && b instanceof Collection) {
            return TestUtils.equalsCollection((Collection)a, (Collection)b);
        }
        return a.equals(b);
    }

    private static boolean equalsMap(Map a, Map b) {
        if (!TestUtils.equalsCollection(a.keySet(), b.keySet())) {
            return false;
        }
        for (Map.Entry entryObject : a.entrySet()) {
            Map.Entry entry = entryObject;
            if (TestUtils.equalsPrivate(entry.getValue(), b.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsCollection(Collection a, Collection b) {
        return TestUtils.containsAll(a, b) && TestUtils.containsAll(b, a);
    }

    private static boolean containsAll(Collection a, Collection b) {
        return a.containsAll(b);
    }

    public static <R> R newProxyInstance(Class<R> clazz, InvocationHandler handler) {
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler));
    }

    public static InvocationHandler getServletToMapHandler(final Map<String, Object> actualMap) {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("getAttributeNames".equals(method.getName())) {
                    return new Enumeration(actualMap){
                        private final Iterator it;
                        {
                            this.it = map.keySet().iterator();
                        }

                        public boolean hasMoreElements() {
                            return this.it.hasNext();
                        }

                        public Object nextElement() {
                            return this.it.next();
                        }
                    };
                }
                if ("setAttribute".equals(method.getName())) {
                    actualMap.put((String)args[0], args[1]);
                    return null;
                }
                if ("removeAttribute".equals(method.getName())) {
                    actualMap.remove(args[0]);
                    return null;
                }
                return actualMap.get(args[0]);
            }
        };
    }

    public static InvocationHandler getMockHandler() {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?> r = method.getReturnType();
                if (r.isPrimitive()) {
                    if (Byte.TYPE.equals(r)) {
                        return (byte)0;
                    }
                    if (Short.TYPE.equals(r)) {
                        return (short)0;
                    }
                    if (Integer.TYPE.equals(r)) {
                        return 0;
                    }
                    if (Long.TYPE.equals(r)) {
                        return 0L;
                    }
                    if (Float.TYPE.equals(r)) {
                        return Float.valueOf(0.0f);
                    }
                    if (Double.TYPE.equals(r)) {
                        return 0.0;
                    }
                    if (Character.TYPE.equals(r)) {
                        return Character.valueOf('a');
                    }
                    if (Boolean.TYPE.equals(r)) {
                        return false;
                    }
                }
                return null;
            }
        };
    }
}

