/*
 * Decompiled with CFR 0.152.
 */
package woolpack.misc;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Semaphore;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MiscUtils {
    private MiscUtils() {
    }

    public static <C, R, E extends Exception> Fn<C, R, E> lapTime(final Fn<? super C, ? extends R, ? extends E> fn, final Fn<? super Long, ?, ? extends E> reportFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                long s = System.currentTimeMillis();
                try {
                    Object r = fn.exec(c);
                    return r;
                }
                finally {
                    reportFn.exec(System.currentTimeMillis() - s);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C, R, E extends Exception, E1 extends Exception> Fn<C, R, E> loadBalancer(Fn<Object, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E1> factory, final int length) throws Exception {
        if (length < 1) {
            throw new IllegalArgumentException("length must be equals or more than 1 but " + length);
        }
        final Semaphore[] semaphoreArray = new Semaphore[length];
        final ArrayList<Fn<? super C, ? extends R, ? extends E>> fnList = new ArrayList<Fn<? super C, ? extends R, ? extends E>>(length);
        int i = 0;
        while (i < length) {
            semaphoreArray[i] = new Semaphore(1);
            Fn<Object, Fn<Object, R, E>, E1> fn = factory;
            synchronized (fn) {
                fnList.add(factory.exec(null));
            }
            ++i;
        }
        return new Fn<C, R, E>(){
            private int position = 0;

            @Override
            public R exec(C c) throws Exception {
                int i = this.position;
                while (true) {
                    if (i < length) {
                        if (semaphoreArray[i].tryAcquire()) {
                            try {
                                Object r = ((Fn)fnList.get(i)).exec(c);
                                return r;
                            }
                            finally {
                                semaphoreArray[i].release();
                                this.position = (i + 1) % length;
                            }
                        }
                        Thread.yield();
                        ++i;
                        continue;
                    }
                    i = 0;
                }
            }
        };
    }

    public static <C> Runnable fnRunnable(final Fn<? super C, ?, ? extends RuntimeException> fn, final C c) {
        return new Runnable(){

            public void run() {
                fn.exec(c);
            }
        };
    }

    public static <R> Fn<Object, R, RuntimeException> runnableFn(final Runnable runnable) {
        return new Fn<Object, R, RuntimeException>(){

            @Override
            public R exec(Object c) {
                runnable.run();
                return null;
            }
        };
    }

    public static <C, R> Fn<C, R, InterruptedException> sleep(final long sleepMillis) {
        return new Fn<C, R, InterruptedException>(){

            @Override
            public R exec(C c) throws InterruptedException {
                if (sleepMillis > 0L) {
                    Thread.sleep(sleepMillis);
                }
                return null;
            }
        };
    }

    public static <R, E extends Exception> Fn<Locale, R, E> switchNearLocale(final Map<? super Locale, ? extends R> map, final Fn<? super Locale, ? extends R, ? extends E> defaultFn) {
        return new Fn<Locale, R, E>(){
            private static final int LOCALE_DEPTH = 3;

            private int calcLocaleCount(Locale key) {
                return key.getVariant() != null && key.getVariant().length() > 0 ? 3 : (key.getCountry() != null && key.getCountry().length() > 0 ? 2 : 1);
            }

            @Override
            public R exec(Locale c) throws Exception {
                Object r = map.get(c);
                if (r != null) {
                    return r;
                }
                if (c == null) {
                    return defaultFn.exec(c);
                }
                int keyCount = this.calcLocaleCount(c);
                Locale l0 = null;
                int count0 = 0;
                for (Object object : map.keySet()) {
                    Locale l1;
                    if (!(object instanceof Locale) || keyCount < this.calcLocaleCount(l1 = (Locale)object)) continue;
                    int count1 = 0;
                    if (c.getLanguage() != null && c.getLanguage().equals(l1.getLanguage())) {
                        ++count1;
                        if (c.getCountry() != null && c.getCountry().equals(l1.getCountry())) {
                            ++count1;
                        }
                    }
                    if (count0 >= count1) continue;
                    count0 = count1;
                    l0 = l1;
                }
                if (l0 == null) {
                    return defaultFn.exec(c);
                }
                return map.get(l0);
            }
        };
    }

    public static <R> Fn<Object, R, RuntimeException> threadLocal(final ThreadLocal<? extends R> threadLocal) {
        return new Fn<Object, R, RuntimeException>(){

            @Override
            public R exec(Object c) {
                return threadLocal.get();
            }
        };
    }

    public static <R, E extends Exception> Fn<String, R, E> tryLocales(final Fn<? super String, ? extends R, ? extends Exception> fn, final ThreadLocal<Locale> threadLocal, final Fn<? super Exception, ?, ? extends E> errorFn, final Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new Fn<String, R, E>(){

            private String removeRight(String s, int i) {
                return s.substring(0, s.length() - i);
            }

            @Override
            public R exec(String id) throws Exception {
                String[] idArray;
                Locale l = (Locale)threadLocal.get();
                Locale d = Locale.getDefault();
                idArray = l == null ? new String[]{String.valueOf(id) + '_' + d.getLanguage() + '_' + d.getCountry() + '_' + d.getVariant(), this.removeRight(idArray[0], d.getVariant().length() + 1), this.removeRight(idArray[1], d.getCountry().length() + 1), id} : new String[]{String.valueOf(id) + '_' + l.getLanguage() + '_' + l.getCountry() + '_' + l.getVariant(), this.removeRight(idArray[0], l.getVariant().length() + 1), this.removeRight(idArray[1], l.getCountry().length() + 1), String.valueOf(id) + '_' + d.getLanguage() + '_' + d.getCountry() + '_' + d.getVariant(), this.removeRight(idArray[3], d.getVariant().length() + 1), this.removeRight(idArray[4], d.getCountry().length() + 1), id};
                Exception e0 = null;
                int i = 0;
                while (i < idArray.length) {
                    try {
                        Object r = fn.exec(idArray[i]);
                        if (r != null) {
                            return r;
                        }
                    }
                    catch (Exception e) {
                        e0 = e;
                        errorFn.exec(e0);
                    }
                    ++i;
                }
                return finalFn.exec(e0);
            }
        };
    }

    public static <R> Fn<String, R, IllegalStateException> tryLocales(Fn<? super String, ? extends R, ? extends Exception> fn, ThreadLocal<Locale> threadLocal) {
        return MiscUtils.tryLocales(fn, threadLocal, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }

    public static <C, R, E extends Exception> Fn<C, R, E> retry(final Fn<? super C, ? extends R, ? extends Exception> fn, final int count, final Fn<? super Exception, ?, ? extends E> errorFn, final Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                Exception t = null;
                int i = 0;
                while (i < count) {
                    try {
                        return fn.exec(c);
                    }
                    catch (Exception e) {
                        t = e;
                        errorFn.exec(t);
                        ++i;
                    }
                }
                return finalFn.exec(t);
            }
        };
    }

    public static <C, R> Fn<C, R, IllegalStateException> retry(Fn<? super C, ? extends R, ? extends Exception> fn, int count) {
        return MiscUtils.retry(fn, count, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }
}

