/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.hello;

import java.util.List;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.adapter.JXPUtils;
import woolpack.samples.SamplesAllTests;
import woolpack.test.TestDomContextBuilder;
import woolpack.xml.XmlTransformerUtils;

public class HelloServletTest extends TestCase {
	public void testNormal() throws Exception {
		final HelloServlet servlet = new HelloServlet();
		servlet.toNode.setFn(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/hello/$1.html"));
		final TestDomContextBuilder builder = new TestDomContextBuilder(JXPUtils.ONE);
		
		builder.init();
		builder.get().setId("index");
		servlet.fn.exec(builder.get());
		
		System.out.println(XmlTransformerUtils.convert(builder.get().getNode()));
		final Map<String, List<Object>> result = builder.selectEmbedded();
		assertEquals(1, result.size());
		assertEquals(1, result.get("message").size());
		assertTrue(result.get("message").get(0).toString().matches("hello \\w\\w\\w \\w\\w\\w \\d\\d \\d\\d:\\d\\d:\\d\\d \\w\\w\\w \\d\\d\\d\\d"));
	}
}
