/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import javax.sql.DataSource;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.sql.fn.PreparedStatementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInput<C, R>
implements Fn<C, R, Exception> {
    private DataSource dataSource;
    private Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> queryFactory;
    private Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter;
    private Fn<? super SQLException, ?, ? extends Exception> errorFn;
    private Fn<String, ? extends GettingEL, ? extends Exception> elFactory;

    public BeanInput(DataSource dataSource, Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> queryFactory, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn, Fn<String, ? extends GettingEL, ? extends Exception> elFactory) {
        this.dataSource = dataSource;
        this.queryFactory = queryFactory;
        this.converter = converter;
        this.errorFn = errorFn;
        this.elFactory = elFactory;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public R exec(C c) throws Exception {
        SQLException e0;
        block16: {
            e0 = null;
            try {
                Connection connection = this.dataSource.getConnection();
                PreparedStatementInfo info = this.queryFactory.exec(c);
                PreparedStatement statement = connection.prepareStatement(info.getQuery());
                int i = 0;
                while (i < info.getList().size()) {
                    String propertyName = info.getList().get(i);
                    Iterable iterable = (Iterable)this.elFactory.exec(propertyName).getValue(c, Iterable.class);
                    Iterator iterator = iterable.iterator();
                    statement.setObject(i + 1, iterator.hasNext() ? iterator.next() : null);
                    ++i;
                }
                statement.execute();
                R r = this.converter.exec(statement);
                statement.close();
                connection.close();
                return r;
                {
                    catch (SQLException e1) {
                        try {
                            try {
                                try {
                                    this.errorFn.exec(e1);
                                    e0 = e1;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    statement.close();
                                }
                            }
                            catch (SQLException e12) {
                                this.errorFn.exec(e12);
                                if (e0 == null) {
                                    e0 = e12;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            connection.close();
                        }
                    }
                }
            }
            catch (SQLException e1) {
                this.errorFn.exec(e1);
                if (e0 != null) break block16;
                e0 = e1;
            }
        }
        if (e0 != null) {
            throw e0;
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Fn<? super PreparedStatement, ? extends R, ? extends Exception> getConverter() {
        return this.converter;
    }

    public void setConverter(Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter) {
        this.converter = converter;
    }

    public Fn<? super SQLException, ?, ? extends Exception> getErrorFn() {
        return this.errorFn;
    }

    public void setErrorFn(Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        this.errorFn = errorFn;
    }

    public Fn<String, ? extends GettingEL, ? extends Exception> getElFactory() {
        return this.elFactory;
    }

    public void setElFactory(Fn<String, ? extends GettingEL, ? extends Exception> elFactory) {
        this.elFactory = elFactory;
    }

    public Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> getQueryFactory() {
        return this.queryFactory;
    }

    public void setQueryFactory(Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> queryFactory) {
        this.queryFactory = queryFactory;
    }
}

