/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.factory.ConcurrentMapCache;
import woolpack.factory.GettingELFn;
import woolpack.factory.InputStreamReaderFactory;
import woolpack.factory.MapCache;
import woolpack.factory.NewInstanceFactory;
import woolpack.factory.SideEffectConcurrentMapCache;
import woolpack.factory.SideEffectMapCache;
import woolpack.factory.StringInputStreamFactory;
import woolpack.factory.StringReaderFactory;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryUtils {
    public static final Fn<Object, Map<String, Object>, RuntimeException> LINKED_MAP_FACTORY = new Fn<Object, Map<String, Object>, RuntimeException>(){

        @Override
        public Map<String, Object> exec(Object c) {
            return new LinkedHashMap<String, Object>();
        }
    };

    private FactoryUtils() {
    }

    public static <C, K, E extends Exception> Fn<C, Object, E> cache(Fn<? super C, ? extends Map<? super K, Object>, ? extends E> mapGetter, Fn<? super C, K, ? extends E> keyGetter, Fn<? super C, ?, ? extends E> maker) {
        return new MapCache<C, K, E>(mapGetter, keyGetter, maker);
    }

    public static <C, K, E extends Exception> Fn<C, Object, E> concurrentCache(Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter, Fn<? super C, K, ? extends E> keyGetter, Fn<? super C, ?, ? extends E> maker) {
        return new ConcurrentMapCache<C, K, E>(mapGetter, keyGetter, maker);
    }

    public static <C, K, E extends Exception> Fn<C, Void, E> cache(Fn<? super C, ? extends Map<? super K, Object>, ? extends E> mapGetter, Fn<? super C, ? extends K, ? extends E> keyGetter, Fn<? super C, ?, ? extends E> maker, EL el) {
        return new SideEffectMapCache<C, K, E>(mapGetter, keyGetter, maker, el);
    }

    public static <C, K, E extends Exception> Fn<C, Void, E> concurrentCache(Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter, Fn<? super C, ? extends K, ? extends E> keyGetter, Fn<? super C, ?, ? extends E> maker, EL el) {
        return new SideEffectConcurrentMapCache<C, K, E>(mapGetter, keyGetter, maker, el);
    }

    public static Fn<Object, Object, RuntimeException> doEL(GettingEL gettingEL) {
        return new GettingELFn<RuntimeException>(gettingEL);
    }

    public static <C> Fn<C, Reader, IOException> inputStreamReaderFactory(Fn<? super C, ? extends InputStream, ? extends IOException> inputStreamFactory, String charset) {
        return new InputStreamReaderFactory<C>(inputStreamFactory, charset);
    }

    public static <R> Fn<Object, R, Exception> newInstance(Class<R> clazz) {
        return new NewInstanceFactory<R>(clazz);
    }

    public static Fn<Object, InputStream, UnsupportedEncodingException> stringInputStreamFactory(String charset, String s) {
        return new StringInputStreamFactory(charset, s);
    }

    public static Fn<Object, StringReader, RuntimeException> stringReaderFactory(String s) {
        return new StringReaderFactory<RuntimeException>(s);
    }
}

