/*
 * Decompiled with CFR 0.152.
 */
package woolpack.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import woolpack.convert.CloneFormatFactory;
import woolpack.convert.FormatConverter;
import woolpack.convert.KeySetGetter;
import woolpack.convert.NetMaskConverter;
import woolpack.convert.ParseConverter;
import woolpack.convert.RegExpConverter;
import woolpack.convert.RetainKeys;
import woolpack.convert.ToBigDecimalConverter;
import woolpack.convert.ToBigIntegerConverter;
import woolpack.convert.ToByteConverter;
import woolpack.convert.ToCalendarConverter;
import woolpack.convert.ToDoubleConverter;
import woolpack.convert.ToFloatConverter;
import woolpack.convert.ToIntegerConverter;
import woolpack.convert.ToLongConverter;
import woolpack.convert.ToShortConverter;
import woolpack.convert.ToSqlDateConverter;
import woolpack.convert.ToStringConverter;
import woolpack.convert.ToTimeConverter;
import woolpack.convert.ToTimestampConverter;
import woolpack.convert.TrysFn;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertUtils {
    public static final Fn<Object, BigDecimal, RuntimeException> TO_BIG_DECIMAL = new ToBigDecimalConverter<RuntimeException>();
    public static final Fn<Object, BigInteger, RuntimeException> TO_BIG_INTEGER = new ToBigIntegerConverter<RuntimeException>();
    public static final Fn<Object, Byte, RuntimeException> TO_BYTE = new ToByteConverter<RuntimeException>();
    public static final Fn<Object, Double, RuntimeException> TO_DOUBLE = new ToDoubleConverter<RuntimeException>();
    public static final Fn<Object, Float, RuntimeException> TO_FLOAT = new ToFloatConverter<RuntimeException>();
    public static final Fn<Object, Integer, RuntimeException> TO_INTEGER = new ToIntegerConverter<RuntimeException>();
    public static final Fn<Object, Long, RuntimeException> TO_LONG = new ToLongConverter<RuntimeException>();
    public static final Fn<Object, Short, RuntimeException> TO_SHORT = new ToShortConverter<RuntimeException>();
    public static final Fn<Object, Date, RuntimeException> TO_SQL_DATE = new ToSqlDateConverter<RuntimeException>();
    public static final Fn<Object, Time, RuntimeException> TO_TIME = new ToTimeConverter<RuntimeException>();
    public static final Fn<Object, Timestamp, RuntimeException> TO_TIMESTAMP = new ToTimestampConverter<RuntimeException>();
    public static final Fn<Object, Calendar, RuntimeException> TO_CALENDAR = new ToCalendarConverter<RuntimeException>();
    public static final Fn<Object, String, RuntimeException> TO_STRING = new ToStringConverter<RuntimeException>();

    private ConvertUtils() {
    }

    public static <K> Fn<Map<K, ?>, Set<K>, RuntimeException> keySet() {
        return new KeySetGetter();
    }

    public static Fn<Object, Format, RuntimeException> formatFactory(Format format) {
        return new CloneFormatFactory<RuntimeException>(format);
    }

    public static <E extends Exception> Fn<Object, String, E> format(Fn<?, ? extends Format, ? extends E> formatFactory) {
        return new FormatConverter<E>(formatFactory);
    }

    public static Fn<String, String, RuntimeException> netMask(String netMask) {
        return new NetMaskConverter<RuntimeException>(netMask);
    }

    public static Fn<String, Object, Exception> parse(Fn<?, ? extends Format, ? extends Exception> formatFactory) {
        return new ParseConverter(formatFactory);
    }

    public static Fn<String, String, RuntimeException> convertRegExp(Pattern pattern, String replacement) {
        return new RegExpConverter<RuntimeException>(pattern, replacement);
    }

    public static <C, R, E extends Exception> Fn<C, R, E> trys(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable, Fn<? super Exception, ?, ? extends E> errorFn, Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new TrysFn(iterable, errorFn, finalFn);
    }

    public static <C, R> Fn<C, R, IllegalStateException> trys(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable) {
        return ConvertUtils.trys(iterable, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }

    public static Fn<Map<?, ?>, Boolean, RuntimeException> retainKeys(Collection<?> collection) {
        return new RetainKeys(collection);
    }
}

