/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.acquirable;

import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import junit.framework.TestCase;
import woolpack.LoadAllTests;
import woolpack.test.RunnableGate;
import woolpack.test.RunnableGate.Context;

public class TryLockTest extends TestCase {
	public void testNormal() {
		final Lock lock = new ReentrantLock();
		final Acquirable<RuntimeException> acquirable = AcquirableUtils.tryLock(lock);

		final RunnableGate gate = new RunnableGate(LoadAllTests.THREAD_POOL);
		final Runnable runnable = new Runnable() {
			public void run() {
				if (acquirable.acquire()) {
					try {
						gate.getPause("pause", "resume").run();
					} finally {
						acquirable.release();
					}
				} else {
					gate.getGate("false").run();
				}
			}
		};

		final Context context0 = gate.execute(runnable);
		assertTrue(context0.waitFor("pause"));
		assertFalse(context0.waitFor("resume"));

		final Context context1 = gate.execute(runnable);
		assertEquals(Arrays.asList("false"), context1.getEndList());

		context0.resume();
		assertEquals(Arrays.asList("pause", "resume"), context0.getEndList());
	}
}
