/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.acquirable;

import junit.framework.TestCase;

public class AcquirableUtilsTest extends TestCase {
	private int count = 100;

	public void testAny() {
		for (int i = 0; i < count; i++) {
			assertTrue(AcquirableUtils.ANY.acquire());
		}
		for (int i = 0; i < count; i++) {
			AcquirableUtils.ANY.release();
		}
	}

	public void testNone() {
		for (int i = 0; i < count; i++) {
			AcquirableUtils.NONE.release();
		}
		for (int i = 0; i < count; i++) {
			assertFalse(AcquirableUtils.NONE.acquire());
		}
	}

	public void testInterrupt() {
		assertFalse(AcquirableUtils.INTERRUPT.acquire());
		assertTrue(Thread.currentThread().isInterrupted());
		Thread.interrupted();
		AcquirableUtils.INTERRUPT.release();
	}

	public void testInterruptedException() {
		try {
			AcquirableUtils.INTERRUPTED_EXCEPTION.acquire();
			fail();
		} catch (final InterruptedException e) {
		}
		assertTrue(Thread.currentThread().isInterrupted());
		Thread.interrupted();
		AcquirableUtils.INTERRUPTED_EXCEPTION.release();
	}
}
