/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Node;

/**
 * 単純な{@link NodeContext}実装です。
 * <br/>適用しているデザインパターン：変数を格納するだけの構造体。
 * @author nakamura
 *
 */
public class SimpleNodeContext implements NodeContext {
	private Node node;
	public Node getNode() {
		return node;
	}
	public void setNode(final Node node) {
		this.node = node;
	}
}
