/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import woolpack.bool.BooleanState;
import woolpack.fn.Fn;

public class NameBranchIfNotEmpty<E extends Exception> extends NameBranch<E> {

	public NameBranchIfNotEmpty(
			final Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator,
			final Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
		super(operator, map);
	}

	@Override
	protected Collection<String> keySet(final ValidatorContext context) {
		final List<String> list = new ArrayList<String>();
		myloop:for (final Entry<String, List<Object>> entry : context.getInputMap().entrySet()) {
			for (final Object object : entry.getValue()) {
				if (object != null && !"".equals(object)) {
					list.add(entry.getKey());
					continue myloop;
				}
			}
		}
		return list;
	}
}
