/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * 委譲先に委譲する{@link Map}です。
 * <br/>適用しているデザインパターン：Delegation。
 * 
 * @author nakamura
 * 
 */
public class DelegationMap<K, V> implements Map<K, V> {
	private Map<K, V> map;

	public DelegationMap(final Map<K, V> map) {
		this.map = map;
	}

	public void clear() {
		map.clear();
	}

	public boolean containsKey(final Object key) {
		return map.containsKey(key);
	}

	public boolean containsValue(final Object value) {
		return map.containsValue(value);
	}

	public Set<Entry<K, V>> entrySet() {
		return map.entrySet();
	}

	public V get(final Object key) {
		return map.get(key);
	}

	public boolean isEmpty() {
		return map.isEmpty();
	}

	public Set<K> keySet() {
		return map.keySet();
	}

	public V put(final K key, final V value) {
		return map.put(key, value);
	}

	public void putAll(final Map<? extends K, ? extends V> t) {
		map.putAll(t);
	}

	public int size() {
		return map.size();
	}

	public Collection<V> values() {
		return map.values();
	}

	public V remove(final Object key) {
		return map.remove(key);
	}

	@Override
	public boolean equals(final Object o) {
		return map.equals(o);
	}

	@Override
	public int hashCode() {
		return map.hashCode();
	}

	@Override
	public String toString() {
		return map.toString();
	}

	public Map<K, V> getMap() {
		return map;
	}

	public void setMap(final Map<K, V> child) {
		this.map = child;
	}
}
