/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Collection;
import java.util.Iterator;

/**
 * 委譲先に委譲する{@link Collection}です。
 * <br/>適用しているデザインパターン：Delegation。
 * 
 * @author nakamura
 * 
 * @param <E>
 */
public class DelegationCollection<E> implements Collection<E> {
	private Collection<E> collection;

	public DelegationCollection(final Collection<E> collection) {
		this.collection = collection;
	}

	public Iterator<E> iterator() {
		return collection.iterator();
	}

	public Object[] toArray() {
		return collection.toArray();
	}

	public <T> T[] toArray(final T[] a) {
		return collection.toArray(a);
	}

	public boolean remove(final Object o) {
		return collection.remove(o);
	}

	public boolean addAll(final Collection<? extends E> c) {
		return collection.addAll(c);
	}

	public boolean removeAll(final Collection<?> c) {
		return collection.removeAll(c);
	}

	public boolean retainAll(final Collection<?> c) {
		return collection.retainAll(c);
	}

	public boolean add(final E o) {
		return collection.add(o);
	}

	public boolean containsAll(final Collection<?> c) {
		return collection.containsAll(c);
	}

	public boolean contains(final Object o) {
		return collection.contains(o);
	}

	public void clear() {
		collection.clear();
	}

	public boolean isEmpty() {
		return collection.isEmpty();
	}

	public int size() {
		return collection.size();
	}

	@Override
	public boolean equals(final Object o) {
		return collection.equals(o);
	}

	@Override
	public int hashCode() {
		return collection.hashCode();
	}

	@Override
	public String toString() {
		return collection.toString();
	}

	public Collection<E> getCollection() {
		return collection;
	}

	public void setCollection(final Collection<E> collection) {
		this.collection = collection;
	}
}
